/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.external.service.ExternalComponentLoader;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.storage.NavTreeStorage;
import org.dashbuilder.transfer.DataTransferAssets;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.DataTransferServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.type.TypeConverterUtil;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Service
public class DataTransferServicesImpl
implements DataTransferServices {
    public static final String VERSION = "1.0.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferServicesImpl.class);
    private IOService ioService;
    private FileSystem datasetsFS;
    private FileSystem perspectivesFS;
    private FileSystem navigationFS;
    private FileSystem systemFS;
    private DataSetDefRegistryCDI dataSetDefRegistryCDI;
    private SessionInfo sessionInfo;
    private Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent;
    private Event<PluginAdded> pluginAddedEvent;
    private Event<NavTreeChangedEvent> navTreeChangedEvent;
    private NavTreeStorage navTreeStorage;
    private byte[] buffer = new byte[1024];
    private ExternalComponentLoader externalComponentLoader;

    public DataTransferServicesImpl() {
    }

    @Inject
    public DataTransferServicesImpl(@Named(value="ioStrategy") IOService ioService, @Named(value="datasetsFS") FileSystem datasetsFS, @Named(value="perspectivesFS") FileSystem perspectivesFS, @Named(value="navigationFS") FileSystem navigationFS, @Named(value="systemFS") FileSystem systemFS, DataSetDefRegistryCDI dataSetDefRegistryCDI, SessionInfo sessionInfo, Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent, Event<PluginAdded> pluginAddedEvent, Event<NavTreeChangedEvent> navTreeChangedEvent, NavTreeStorage navTreeStorage, ExternalComponentLoader externalComponentLoader) {
        this.ioService = ioService;
        this.datasetsFS = datasetsFS;
        this.perspectivesFS = perspectivesFS;
        this.navigationFS = navigationFS;
        this.systemFS = systemFS;
        this.dataSetDefRegistryCDI = dataSetDefRegistryCDI;
        this.sessionInfo = sessionInfo;
        this.dataSetDefRegisteredEvent = dataSetDefRegisteredEvent;
        this.pluginAddedEvent = pluginAddedEvent;
        this.navTreeChangedEvent = navTreeChangedEvent;
        this.navTreeStorage = navTreeStorage;
        this.externalComponentLoader = externalComponentLoader;
    }

    public String doExport(DataTransferExportModel exportModel) throws java.io.IOException {
        String componentsPath;
        String zipLocation = (System.getProperty("java.io.tmpdir") + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip").replace("\\", "/");
        Predicate<Path> readmeFilter = p -> p.toString().toLowerCase().endsWith("readme.md");
        Predicate<Path> datasetsFilter = def -> true;
        Predicate<Path> pagesFilter = page -> true;
        boolean exportNavigation = true;
        if (!exportModel.isExportAll()) {
            datasetsFilter = this.filterDatasets(exportModel.getDatasetDefinitions());
            pagesFilter = this.filterPages(exportModel.getPages());
            exportNavigation = exportModel.isExportNavigation();
        }
        new File(zipLocation).getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(zipLocation);
        ZipOutputStream zos = new ZipOutputStream(fos);
        this.zipFileSystem(this.datasetsFS, zos, readmeFilter.or(datasetsFilter));
        this.zipFileSystem(this.perspectivesFS, zos, readmeFilter.or(pagesFilter));
        if (exportNavigation) {
            this.zipFileSystem(this.navigationFS, zos, p -> true);
        } else {
            this.zipFileSystem(this.navigationFS, zos, readmeFilter);
        }
        if (this.externalComponentLoader.isEnabled() && (componentsPath = this.externalComponentLoader.getExternalComponentsDir()) != null && this.exists(componentsPath)) {
            Path componentsBasePath = Paths.get((String)(SpacesAPI.Scheme.FILE + "://" + componentsPath), (String[])new String[0]);
            this.externalComponentLoader.load().forEach(c -> {
                Path componentPath = componentsBasePath.resolve(c.getId());
                this.zipComponentFiles(componentsBasePath, componentPath, zos, p -> true);
            });
        }
        this.zipFile(this.createVersionFile(), "VERSION", zos);
        zos.close();
        fos.close();
        this.moveZipToFileSystem(zipLocation, this.systemFS);
        return (SpacesAPI.Scheme.GIT + "://" + this.systemFS.getName() + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip").replace("\\", "/");
    }

    public List<String> doImport() throws Exception {
        final ArrayList<String> imported = new ArrayList<String>();
        Path root = Paths.get((URI)URI.create((SpacesAPI.Scheme.GIT + "://" + this.systemFS.getName() + File.separator).replace("\\", "/")));
        final String expectedPath = (File.separator + "dashbuilder-data-transfer" + File.separator + "import.zip").replace("\\", "/");
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (!path.toString().equalsIgnoreCase(expectedPath)) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    imported.addAll(DataTransferServicesImpl.this.importFiles(path));
                    return FileVisitResult.TERMINATE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
        this.ioService.deleteIfExists(root.resolve(expectedPath), new DeleteOption[0]);
        return imported;
    }

    public DataTransferAssets assetsToExport() {
        List pages = this.listPaths(this.perspectivesFS, p -> p.endsWith(".plugin")).stream().map(p -> p.getName(p.getNameCount() - 2)).map(Object::toString).collect(Collectors.toList());
        List datasetsDefs = this.listPaths(this.datasetsFS, p -> p.endsWith(".dset")).stream().map(this::getDataSetFileContent).map(this::parseDataSetDefinition).filter(DataSetDef::isPublic).collect(Collectors.toList());
        return new DataTransferAssets(datasetsDefs, pages);
    }

    private List<String> importFiles(Path path) throws Exception {
        File destDir;
        ArrayList<String> imported;
        block18: {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir.lastIndexOf(47) == tmpDir.length() - 1 || tmpDir.lastIndexOf(92) == tmpDir.length() - 1) {
                tmpDir = tmpDir.substring(0, tmpDir.length() - 1);
            }
            String tempPath = (tmpDir + File.separator + "dashbuilder-data-transfer" + File.separator).replace("\\", "/");
            imported = new ArrayList<String>();
            destDir = new File(tempPath);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(path.toFile()));
            Throwable throwable = null;
            block11: while (true) {
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zis.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        File newFile = this.unzipFile(destDir, zipEntry, zis);
                        FileSystem fileSystem = this.getImportFileSystem(newFile, tempPath);
                        if (fileSystem != null) {
                            String newFilePath = this.importFSFile(fileSystem.getName(), newFile, tempPath);
                            imported.add(fileSystem.getName() + newFilePath);
                        }
                        if (!this.isComponent(zipEntry) || this.externalComponentLoader.getExternalComponentsDir() == null || !this.externalComponentLoader.isEnabled()) continue;
                        try {
                            this.importComponentFile(zipEntry.getName(), newFile);
                            imported.add(zipEntry.getName());
                            continue block11;
                        }
                        catch (Exception e) {
                            LOGGER.error("Error importing component file {}", (Object)zipEntry.getName());
                            LOGGER.debug("Component file import error.", (Throwable)e);
                        }
                    }
                    break block18;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (zis != null) {
                    if (throwable != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zis.close();
                    }
                }
            }
        }
        FileUtils.deleteDirectory((File)destDir);
        return imported;
    }

    private boolean isComponent(ZipEntry zipEntry) {
        return zipEntry.getName() != null && zipEntry.getName().startsWith("dashbuilder/components/");
    }

    private String importComponentFile(String entryName, File newFile) {
        String externalComponentsDir = this.externalComponentLoader.getExternalComponentsDir();
        externalComponentsDir = externalComponentsDir.endsWith(File.separator) ? externalComponentsDir : externalComponentsDir + "/";
        String newFileName = externalComponentsDir + entryName.replaceAll("dashbuilder/components/", "");
        this.copyFileContents(newFile, newFileName);
        return newFileName;
    }

    private void copyFileContents(File newFile, String newFileName) {
        File target = new File(newFileName);
        target.getParentFile().mkdirs();
        if (!target.exists()) {
            this.ioService.copy(Paths.get((URI)newFile.toURI()), Paths.get((URI)target.toURI()), new CopyOption[0]);
        }
    }

    private String importFSFile(String fsName, File newFile, String workingDir) throws Exception {
        URI uri = URI.create((SpacesAPI.Scheme.GIT + "://" + fsName).replace("\\", "/"));
        String newFilePath = newFile.toPath().toString().replace("\\", "/").replace(new StringBuilder(workingDir).append(fsName), "");
        this.ioService.write(Paths.get((URI)uri).resolve(newFilePath), java.nio.file.Files.readAllBytes(newFile.toPath()), new OpenOption[0]);
        this.fireEvent(newFile, workingDir, uri, newFilePath);
        return newFilePath;
    }

    private void fireEvent(File newFile, String tempPath, URI uri, String newFilePath) {
        String filePath = newFile.toURI().toString();
        if (filePath.contains(tempPath + this.datasetsFS.getName()) && newFilePath.endsWith(".dset")) {
            this.fireDatasetEvent(uri, newFilePath);
        } else if (filePath.contains(tempPath + this.perspectivesFS.getName()) && newFilePath.endsWith(".plugin")) {
            this.firePerspectiveEvent(newFile, uri, newFilePath);
        } else if (filePath.contains(tempPath + this.navigationFS.getName()) && newFilePath.endsWith("navtree.json")) {
            this.fireNavigationEvent();
        }
    }

    private void fireDatasetEvent(URI uri, String newFilePath) {
        try {
            String json = this.ioService.readAllString(Paths.get((URI)uri).resolve(newFilePath));
            DataSetDef newDef = this.dataSetDefRegistryCDI.getDataSetDefJsonMarshaller().fromJson(json);
            this.dataSetDefRegisteredEvent.fire((Object)new DataSetDefRegisteredEvent(newDef));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void firePerspectiveEvent(File newFile, URI uri, String newFilePath) {
        org.uberfire.backend.vfs.Path pluginPath = org.uberfire.backend.server.util.Paths.convert((Path)Paths.get((URI)uri).resolve(newFilePath));
        Plugin plugin = new Plugin(newFile.toPath().getParent().getFileName().toString(), TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)pluginPath), pluginPath);
        this.pluginAddedEvent.fire((Object)new PluginAdded(plugin, this.sessionInfo));
    }

    private void fireNavigationEvent() {
        this.navTreeChangedEvent.fire((Object)new NavTreeChangedEvent(this.navTreeStorage.loadNavTree()));
    }

    private FileSystem getImportFileSystem(File file, String tempPath) {
        List<FileSystem> fileSystems = Arrays.asList(this.datasetsFS, this.perspectivesFS, this.navigationFS);
        String filePath = file.toURI().toString().replace("\\", "/");
        return fileSystems.stream().filter(fs -> filePath.contains(tempPath + fs.getName())).findFirst().orElse(null);
    }

    private void moveZipToFileSystem(String zipLocation, FileSystem fileSystem) {
        String sourceLocation = SpacesAPI.Scheme.FILE + ":///" + zipLocation;
        Path source = Paths.get((URI)URI.create(sourceLocation));
        Path target = Paths.get((URI)URI.create((SpacesAPI.Scheme.GIT + "://" + fileSystem.getName() + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip").replace("\\", "/")));
        this.ioService.write(target, Files.readAllBytes((Path)source), new OpenOption[0]);
        Files.delete((Path)source, (DeleteOption[])new DeleteOption[0]);
    }

    private File unzipFile(File destinationDir, ZipEntry zipEntry, ZipInputStream zis) throws java.io.IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        if (!destFile.exists()) {
            destFile.getParentFile().mkdirs();
            if (!destFile.createNewFile()) {
                throw new IOException("could not create file " + destFile.getPath());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(destFile);){
            int len;
            while ((len = zis.read(this.buffer)) > 0) {
                fos.write(this.buffer, 0, len);
            }
        }
        return destFile;
    }

    private void zipFileSystem(final FileSystem fs, final ZipOutputStream zos, final Predicate<Path> pathTest) {
        Path root = (Path)fs.getRootDirectories().iterator().next();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                try {
                    if (pathTest.test(path)) {
                        String location = fs.getName() + path.toString();
                        DataTransferServicesImpl.this.zipFile(path.toFile(), location, zos);
                    }
                    return FileVisitResult.CONTINUE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
    }

    private void zipComponentFiles(final Path componentsRoot, Path componentRoot, final ZipOutputStream zos, final Predicate<Path> pathTest) {
        Files.walkFileTree((Path)componentRoot, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                try {
                    if (pathTest.test(path)) {
                        File file = path.toFile();
                        Path relativePath = componentsRoot.relativize(path);
                        String location = "dashbuilder/components/" + relativePath.toString();
                        DataTransferServicesImpl.this.zipFile(file, location, zos);
                    }
                    return FileVisitResult.CONTINUE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
    }

    private void zipFile(File file, String path, ZipOutputStream zos) throws java.io.IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(path);
            zos.putNextEntry(zipEntry);
            while ((length = fis.read(this.buffer)) >= 0) {
                zos.write(this.buffer, 0, length);
            }
            zos.closeEntry();
        }
    }

    private File createVersionFile() throws java.io.IOException {
        File version = File.createTempFile("temp", "version");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(version));){
            out.write(VERSION);
        }
        return version;
    }

    private List<Path> listPaths(FileSystem fs, final Predicate<String> pathTester) {
        final ArrayList<Path> files = new ArrayList<Path>();
        Path root = (Path)fs.getRootDirectories().iterator().next();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                try {
                    if (pathTester.test(path.toString())) {
                        files.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
        return files;
    }

    private String getDataSetFileContent(Path path) {
        return Files.readAllLines((Path)path, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining());
    }

    private DataSetDef parseDataSetDefinition(String defJson) {
        try {
            return this.dataSetDefRegistryCDI.getDataSetDefJsonMarshaller().fromJson(defJson);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing dataset definition", (Throwable)e);
            LOGGER.debug("Json Definition: {}", (Object)defJson);
            throw new IllegalArgumentException(e);
        }
    }

    private Predicate<Path> filterPages(List<String> pages) {
        return page -> {
            if (pages.isEmpty()) {
                return false;
            }
            int nameCount = page.getNameCount();
            if (nameCount > 1) {
                return pages.stream().anyMatch(p -> page.getName(nameCount - 2).toString().equals(p));
            }
            return false;
        };
    }

    private Predicate<Path> filterDatasets(List<DataSetDef> datasets) {
        return dsPath -> {
            if (datasets.isEmpty()) {
                return false;
            }
            int nameCount = dsPath.getNameCount();
            if (nameCount > 1) {
                String fileName = dsPath.getName(nameCount - 1).toString().split("\\.")[0];
                return datasets.stream().anyMatch(ds -> ds.getUUID().equals(fileName));
            }
            return false;
        };
    }

    private boolean exists(String file) {
        return java.nio.file.Files.exists(java.nio.file.Paths.get(file, new String[0]), new LinkOption[0]);
    }
}

