/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.shared.service;

import java.util.Collection;
import java.util.Optional;
import org.dashbuilder.shared.model.DashbuilderRuntimeMode;
import org.dashbuilder.shared.model.RuntimeModel;
import org.dashbuilder.shared.service.RuntimeModelRegistry;
import org.junit.Assert;
import org.junit.Test;

public class RuntimeModelRegistryTest {
    @Test
    public void testAcceptingNewImportsMultiple() {
        RuntimeModelRegistryMock registry = new RuntimeModelRegistryMock(DashbuilderRuntimeMode.MULTIPLE_IMPORT, false);
        Assert.assertTrue((boolean)registry.acceptingNewImports());
    }

    @Test
    public void testNotAcceptingNewImportsStatic() {
        RuntimeModelRegistryMock registry = new RuntimeModelRegistryMock(DashbuilderRuntimeMode.STATIC, false);
        Assert.assertFalse((boolean)registry.acceptingNewImports());
    }

    @Test
    public void testNotAcceptingNewImportsSingleAndNotEmpty() {
        RuntimeModelRegistryMock registry = new RuntimeModelRegistryMock(DashbuilderRuntimeMode.SINGLE_IMPORT, false);
        Assert.assertFalse((boolean)registry.acceptingNewImports());
    }

    @Test
    public void testNotAcceptingNewImportsSingleAndEmpty() {
        RuntimeModelRegistryMock registry = new RuntimeModelRegistryMock(DashbuilderRuntimeMode.SINGLE_IMPORT, true);
        Assert.assertTrue((boolean)registry.acceptingNewImports());
    }

    public class RuntimeModelRegistryMock
    implements RuntimeModelRegistry {
        private DashbuilderRuntimeMode mode;
        private boolean b;

        public RuntimeModelRegistryMock(DashbuilderRuntimeMode mode, boolean b) {
            this.mode = mode;
            this.b = b;
        }

        public Optional<RuntimeModel> single() {
            return null;
        }

        public boolean isEmpty() {
            return this.b;
        }

        public DashbuilderRuntimeMode getMode() {
            return this.mode;
        }

        public Optional<RuntimeModel> get(String id) {
            return null;
        }

        public void setMode(DashbuilderRuntimeMode mode) {
        }

        public Optional<RuntimeModel> registerFile(String filePath) {
            return null;
        }

        public void remove(String runtimeModelid) {
        }

        public Collection<String> availableModels() {
            return null;
        }
    }
}

