/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend.services.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.dashbuilder.backend.services.impl.RuntimeInfoServiceImpl;
import org.dashbuilder.shared.model.DashboardInfo;
import org.dashbuilder.shared.model.DashbuilderRuntimeInfo;
import org.dashbuilder.shared.model.DashbuilderRuntimeMode;
import org.dashbuilder.shared.model.RuntimeModel;
import org.dashbuilder.shared.service.RuntimeModelRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeInfoServiceImplTest {
    static final String RUNTIME_MODEL_ID = "ID";
    static final String NOT_FOUND_ID = "NOT FOUND";
    static final String LT_NAME = "LAYOUT TEMPLATE";
    @Mock
    RuntimeModel runtimeModel;
    @Mock
    RuntimeModelRegistry registry;
    @InjectMocks
    RuntimeInfoServiceImpl runtimeInfoService;

    @Before
    public void init() {
        LayoutTemplate lt = new LayoutTemplate(LT_NAME);
        Mockito.when((Object)this.runtimeModel.getLayoutTemplates()).thenReturn(Arrays.asList(lt));
        Mockito.when((Object)this.registry.getMode()).thenReturn((Object)DashbuilderRuntimeMode.MULTIPLE_IMPORT);
        Mockito.when((Object)this.registry.get(RUNTIME_MODEL_ID)).thenReturn(Optional.of(this.runtimeModel));
        Mockito.when((Object)this.registry.get(NOT_FOUND_ID)).thenReturn(Optional.empty());
        Mockito.when((Object)this.registry.availableModels()).thenReturn(new HashSet<String>(Arrays.asList(RUNTIME_MODEL_ID)));
    }

    @Test
    public void testInfo() {
        DashbuilderRuntimeInfo info = this.runtimeInfoService.info();
        Assert.assertEquals((long)1L, (long)info.getAvailableModels().size());
        Assert.assertTrue((boolean)info.getAvailableModels().contains(RUNTIME_MODEL_ID));
        Assert.assertEquals((Object)DashbuilderRuntimeMode.MULTIPLE_IMPORT.name(), (Object)info.getMode());
        Assert.assertFalse((boolean)info.isAcceptingNewImports());
    }

    @Test
    public void testDashboardInfoWithFoundModel() {
        Optional dashboardInfoOp = this.runtimeInfoService.dashboardInfo(RUNTIME_MODEL_ID);
        DashboardInfo dashboardInfo = (DashboardInfo)dashboardInfoOp.get();
        Assert.assertEquals((long)1L, (long)dashboardInfo.getPages().size());
        Assert.assertTrue((boolean)dashboardInfo.getPages().contains(LT_NAME));
        Assert.assertEquals((Object)RUNTIME_MODEL_ID, (Object)dashboardInfo.getRuntimeModelId());
    }

    @Test
    public void testDashboardInfoWithNotFoundModel() {
        Optional dashboardInfoOp = this.runtimeInfoService.dashboardInfo(NOT_FOUND_ID);
        Assert.assertFalse((boolean)dashboardInfoOp.isPresent());
    }
}

