/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.dashbuilder.backend.RuntimeModelLoader;
import org.dashbuilder.backend.RuntimeOptions;
import org.dashbuilder.shared.service.RuntimeModelRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeModelLoaderTest {
    Path baseTempDir;
    @Mock
    RuntimeModelRegistry registry;
    @Mock
    RuntimeOptions runtimeOptions;
    @InjectMocks
    RuntimeModelLoader runtimeModelLoader;

    @Before
    public void init() throws IOException {
        this.baseTempDir = Files.createTempDirectory("dashbuilder-tests", new FileAttribute[0]);
    }

    @After
    public void cleanup() {
        FileUtils.deleteQuietly((File)this.baseTempDir.toFile());
    }

    @Test
    public void testCreateBaseDir() {
        String tempPath = Paths.get(this.baseTempDir.toString(), "tmp").toString();
        Mockito.when((Object)this.runtimeOptions.getImportsBaseDir()).thenReturn((Object)tempPath);
        Assert.assertFalse((boolean)Paths.get(tempPath, new String[0]).toFile().exists());
        this.runtimeModelLoader.createBaseDir();
        Assert.assertTrue((boolean)Paths.get(tempPath, new String[0]).toFile().exists());
    }

    @Test
    public void testLoadAvailableModels() throws IOException {
        String baseDir = this.baseTempDir.toString();
        Mockito.when((Object)this.runtimeOptions.getImportsBaseDir()).thenReturn((Object)baseDir);
        Path p1 = Paths.get(baseDir, "model1.zip");
        Path p2 = Paths.get(baseDir, "model2.zip");
        Path p3 = Paths.get(baseDir, "ignored.bkp");
        Path p4 = Paths.get(baseDir, "intermediary", "ignored.bkp");
        p4.toFile().getParentFile().mkdirs();
        for (Path p : Arrays.asList(p1, p2, p3, p4)) {
            p.toFile().createNewFile();
        }
        this.runtimeModelLoader.loadAvailableModels();
        ((RuntimeModelRegistry)Mockito.verify((Object)this.registry)).registerFile(Matchers.matches((String)p1.toString()));
        ((RuntimeModelRegistry)Mockito.verify((Object)this.registry)).registerFile(Matchers.matches((String)p2.toString()));
        ((RuntimeModelRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)0))).registerFile(Matchers.matches((String)p3.toString()));
        ((RuntimeModelRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)0))).registerFile(Matchers.matches((String)p4.toString()));
    }
}

