/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.error;

import org.dashbuilder.client.error.DefaultRuntimeErrorCallback;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRuntimeErrorCallbackTest {
    @Test
    public void testIsServerOfflineException() {
        Assert.assertTrue((boolean)DefaultRuntimeErrorCallback.isServerOfflineException((Throwable)new Exception("Error parsing JSON: SyntaxError: JSON.parse: unexpected character at line 1 column 2 of the JSON data")));
        Assert.assertTrue((boolean)DefaultRuntimeErrorCallback.isServerOfflineException((Throwable)new Exception("Error parsing JSON: SyntaxError: Unexpected token \ufffd in JSON at position 1")));
        Assert.assertTrue((boolean)DefaultRuntimeErrorCallback.isServerOfflineException((Throwable)new Exception("Script error. (:0)")));
        Assert.assertFalse((boolean)DefaultRuntimeErrorCallback.isServerOfflineException((Throwable)new Exception()));
        Assert.assertFalse((boolean)DefaultRuntimeErrorCallback.isServerOfflineException((Throwable)new Exception("any message")));
    }

    @Test
    public void testExtractMessageRecursively() {
        Exception cause = new Exception("CAUSE");
        Exception intermediary = new Exception("INTERMEDIARY", cause);
        Exception e = new Exception("FIRST", intermediary);
        String message = DefaultRuntimeErrorCallback.extractMessageRecursively((Throwable)e);
        Assert.assertEquals((Object)"FIRST Caused by: INTERMEDIARY Caused by: CAUSE", (Object)message);
        String MESSAGE = "Message";
        message = DefaultRuntimeErrorCallback.extractMessageRecursively((Throwable)new Exception(MESSAGE));
        Assert.assertEquals((Object)MESSAGE, (Object)message);
        Assert.assertEquals((Object)"", (Object)DefaultRuntimeErrorCallback.extractMessageRecursively(null));
    }
}

