/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.event.SortEvent;
import com.googlecode.gwt.charts.client.event.SortHandler;
import com.googlecode.gwt.charts.client.options.Options;
import com.googlecode.gwt.charts.client.options.TableSort;
import com.googlecode.gwt.charts.client.table.Table;
import com.googlecode.gwt.charts.client.table.TableOptions;
import org.dashbuilder.renderer.google.client.GoogleDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.IconSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.PaginationSize;

public class GoogleTableDisplayerView
extends GoogleDisplayerView<GoogleTableDisplayer>
implements GoogleTableDisplayer.View {
    private Table table;
    protected int pageSize = 10;
    protected int width = 500;
    protected int totalPages = 1;
    protected int currentPage = 1;
    protected int totalRows = 0;
    protected int leftMostPageNumber = 0;
    protected int rightMostPageNumber = 0;
    protected boolean pagerEnabled = false;
    protected boolean totalPagesHintEnabled = false;
    protected boolean totalRowsHintEnabled = false;

    @Override
    public String getGroupsTitle() {
        return GoogleDisplayerConstants.INSTANCE.common_Rows();
    }

    @Override
    public String getColumnsTitle() {
        return GoogleDisplayerConstants.INSTANCE.common_Columns();
    }

    @Override
    public void createTable() {
        this.table = new Table();
    }

    @Override
    public void setSortEnabled(boolean enabled) {
        if (enabled) {
            this.table.addSortHandler(new SortHandler(){

                public void onSort(SortEvent sortEvent) {
                    String columnId = GoogleTableDisplayerView.this.getDataTable().getColumnId(sortEvent.getColumn());
                    ((GoogleTableDisplayer)GoogleTableDisplayerView.this.getPresenter()).sortBy(columnId);
                }
            });
        }
    }

    @Override
    public void setTotalPagesHintEnabled(boolean enabled) {
        this.totalPagesHintEnabled = enabled;
    }

    @Override
    public void setTotalRowsHintEnabled(boolean enabled) {
        this.totalRowsHintEnabled = enabled;
    }

    @Override
    public void setPageSize(int size) {
        this.pageSize = size;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setPagerEnabled(boolean enabled) {
        this.pagerEnabled = enabled;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    public void setTotalRows(int numberOfRows) {
        this.totalRows = numberOfRows;
    }

    @Override
    public void setTotalPages(int numberOfPages) {
        this.totalPages = numberOfPages;
    }

    @Override
    public void setLeftMostPageNumber(int n) {
        this.leftMostPageNumber = n;
    }

    @Override
    public void setRightMostPageNumber(int n) {
        this.rightMostPageNumber = n;
    }

    @Override
    public void nodata() {
        this.table.draw((DataSource)this.getDataTable(), (Options)this.createOptions());
        FlowPanel tablePanel = new FlowPanel();
        tablePanel.add((Widget)this.table);
        tablePanel.add((Widget)new Label(GoogleDisplayerConstants.INSTANCE.common_noData()));
        super.showDisplayer((Widget)tablePanel);
    }

    @Override
    public void drawTable() {
        this.table.draw((DataSource)this.getDataTable(), (Options)this.createOptions());
        FlowPanel tablePanel = new FlowPanel();
        tablePanel.add((Widget)this.table);
        if (this.pagerEnabled) {
            HorizontalPanel pager = this.createTablePager();
            tablePanel.add((Widget)pager);
        }
        super.showDisplayer((Widget)tablePanel);
    }

    protected TableOptions createOptions() {
        TableOptions options = TableOptions.create();
        options.setSort(TableSort.EVENT);
        options.setPageSize(this.pageSize);
        options.setShowRowNumber(false);
        options.setWidth(this.width);
        return options;
    }

    protected HorizontalPanel createTablePager() {
        HorizontalPanel pagerPanel = new HorizontalPanel();
        pagerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        pagerPanel.getElement().setAttribute("cellpadding", "5");
        Pagination pagination = new Pagination();
        pagination.setPaginationSize(PaginationSize.NONE);
        for (int i = this.leftMostPageNumber; i <= this.rightMostPageNumber; ++i) {
            AnchorListItem pageLink = new AnchorListItem(Integer.toString(i));
            final Integer _currentPage = i;
            if (this.currentPage != i) {
                pageLink.setActive(false);
                pageLink.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ((GoogleTableDisplayer)GoogleTableDisplayerView.this.getPresenter()).gotoPage(_currentPage);
                    }
                });
            } else {
                pageLink.setActive(true);
            }
            pagination.add((Widget)pageLink);
        }
        Icon leftPageIcon = new Icon(IconType.ANGLE_LEFT);
        leftPageIcon.setSize(IconSize.LARGE);
        leftPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        leftPageIcon.sinkEvents(1);
        leftPageIcon.addHandler((EventHandler)this.createGotoPageHandler(this.currentPage - 1), (GwtEvent.Type)ClickEvent.getType());
        Tooltip leftPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoPreviousPage());
        leftPageTooltip.add((Widget)leftPageIcon);
        Icon rightPageIcon = new Icon(IconType.ANGLE_RIGHT);
        rightPageIcon.setSize(IconSize.LARGE);
        rightPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        rightPageIcon.sinkEvents(1);
        rightPageIcon.addHandler((EventHandler)this.createGotoPageHandler(this.currentPage + 1), (GwtEvent.Type)ClickEvent.getType());
        Tooltip rightPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoNextPage());
        rightPageTooltip.add((Widget)rightPageIcon);
        Icon firstPageIcon = new Icon(IconType.ANGLE_DOUBLE_LEFT);
        firstPageIcon.setSize(IconSize.LARGE);
        firstPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        firstPageIcon.sinkEvents(1);
        firstPageIcon.addHandler((EventHandler)this.createGotoPageHandler(1), (GwtEvent.Type)ClickEvent.getType());
        Tooltip firstPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoFirstPage());
        firstPageTooltip.add((Widget)firstPageIcon);
        Icon lastPageIcon = new Icon(IconType.ANGLE_DOUBLE_RIGHT);
        lastPageIcon.setSize(IconSize.LARGE);
        lastPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        lastPageIcon.sinkEvents(1);
        lastPageIcon.addHandler((EventHandler)this.createGotoPageHandler(this.totalPages), (GwtEvent.Type)ClickEvent.getType());
        Tooltip lastPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoLastPage());
        lastPageTooltip.add((Widget)lastPageIcon);
        pagerPanel.add((IsWidget)firstPageTooltip);
        pagerPanel.add((IsWidget)leftPageTooltip);
        pagerPanel.add((Widget)pagination);
        pagerPanel.add((IsWidget)rightPageTooltip);
        pagerPanel.add((IsWidget)lastPageTooltip);
        if (this.totalPagesHintEnabled) {
            pagerPanel.add((Widget)new Label(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_pages(Integer.toString(this.leftMostPageNumber), Integer.toString(this.rightMostPageNumber), Integer.toString(this.totalPages))));
        }
        if (this.totalRowsHintEnabled) {
            int currentRowsShown = this.currentPage * this.pageSize > this.totalRows ? this.totalRows : this.currentPage * this.pageSize;
            pagerPanel.add((Widget)new Label(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_rows(Integer.toString((this.currentPage - 1) * this.pageSize + 1), Integer.toString(currentRowsShown), Integer.toString(this.totalRows))));
        }
        return pagerPanel;
    }

    protected ClickHandler createGotoPageHandler(final int page) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((GoogleTableDisplayer)GoogleTableDisplayerView.this.getPresenter()).gotoPage(page);
            }
        };
    }
}

