/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.external;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.dashbuilder.common.client.widgets.FilterLabel;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPresenter;
import org.dashbuilder.displayer.external.ExternalColumn;
import org.dashbuilder.displayer.external.ExternalColumnSettings;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalDataSet;
import org.dashbuilder.displayer.external.ExternalFilterRequest;

@Dependent
public class ExternalComponentDisplayer
extends AbstractErraiDisplayer<View> {
    @Inject
    View view;
    @Inject
    ExternalComponentPresenter externalComponentPresenter;
    @Inject
    FilterLabelSet filterLabelSet;
    private String componentId;

    public View getView() {
        return this.view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
        this.view.setFilterLabelSet(this.filterLabelSet);
        this.filterLabelSet.setOnClearAllCommand(this::onFilterClearAll);
        this.externalComponentPresenter.setMessageConsumer(this::receiveMessage);
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setExtraColumnsAllowed(true)).setGroupsTitle("Groups").setColumnsTitle("Columns");
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.EXTERNAL_COMPONENT_ID).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute(DisplayerAttributeGroupDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeGroupDef.CHART_HEIGHT).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
    }

    protected void createVisualization() {
        this.updateVisualization();
    }

    protected void updateVisualization() {
        String currentComponentId = this.displayerSettings.getComponentId();
        if (currentComponentId != null && !currentComponentId.equals(this.componentId)) {
            this.componentId = currentComponentId;
            String partitionId = this.displayerSettings.getComponentPartition();
            if (partitionId != null) {
                this.externalComponentPresenter.withComponent(this.componentId, partitionId);
            } else {
                this.externalComponentPresenter.withComponent(this.componentId);
            }
        }
        ExternalComponentMessage message = this.retrieveComponentMessage();
        this.externalComponentPresenter.sendMessage(message);
        this.view.setSize(this.displayerSettings.getChartWidth(), this.displayerSettings.getChartHeight());
        this.view.setMargin(this.displayerSettings.getChartMarginTop(), this.displayerSettings.getChartMarginRight(), this.displayerSettings.getChartMarginBottom(), this.displayerSettings.getChartMarginLeft());
        this.updateFilterStatus();
    }

    private ExternalComponentMessage retrieveComponentMessage() {
        Map componentProperties = this.displayerSettings.getComponentProperties();
        ExternalComponentMessage message = ExternalComponentMessage.create((Map)componentProperties);
        ExternalDataSet ds = ExternalDataSet.of((ExternalColumn[])this.buildColumns(), (String[][])this.buildData(this.dataSet));
        message.setProperty("dataSet", (Object)ds);
        return message;
    }

    private ExternalColumn[] buildColumns() {
        return (ExternalColumn[])this.dataSet.getColumns().stream().map(this::buildExternalColumn).toArray(ExternalColumn[]::new);
    }

    public ExternalComponentPresenter getExternalComponentPresenter() {
        return this.externalComponentPresenter;
    }

    public String[][] buildData(DataSet ds) {
        List columns = ds.getColumns();
        int rows = ((DataColumn)columns.get(0)).getValues().size();
        int cols = columns.size();
        String[][] result = new String[rows][];
        for (int i = 0; i < rows; ++i) {
            String[] line = new String[cols];
            for (int j = 0; j < cols; ++j) {
                line[j] = this.columnValueToString(ds.getValueAt(i, j));
            }
            result[i] = line;
        }
        return result;
    }

    protected String columnValueToString(Object mightBeNull) {
        return mightBeNull == null ? "" : mightBeNull.toString();
    }

    protected ExternalColumn buildExternalColumn(DataColumn cl) {
        ColumnSettings clSettings = this.displayerSettings.getColumnSettings(cl);
        ExternalColumnSettings settings = ExternalColumnSettings.of((String)clSettings.getColumnId(), (String)clSettings.getColumnName(), (String)clSettings.getValueExpression(), (String)clSettings.getEmptyTemplate(), (String)clSettings.getValuePattern());
        return ExternalColumn.of((String)cl.getId(), (String)cl.getColumnType().name(), (ExternalColumnSettings)settings);
    }

    protected void updateFilterStatus() {
        this.filterLabelSet.clear();
        Set columnFilters = this.filterColumns();
        if (this.displayerSettings.isFilterEnabled() && !columnFilters.isEmpty()) {
            for (String columnId : columnFilters) {
                List selectedValues = this.filterIntervals(columnId);
                DataColumn column = this.dataSet.getColumnById(columnId);
                for (Interval interval : selectedValues) {
                    String formattedValue = this.formatInterval(interval, column);
                    FilterLabel filterLabel = this.filterLabelSet.addLabel(formattedValue);
                    filterLabel.setOnRemoveCommand(() -> this.onFilterLabelRemoved(columnId, interval.getIndex()));
                }
            }
        }
    }

    protected void onFilterLabelRemoved(String columnId, int row) {
        super.filterUpdate(columnId, row);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    protected void onFilterClearAll() {
        super.filterReset();
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    private void receiveMessage(ExternalComponentMessage message) {
        Object filterProp = message.getProperty("filter");
        if (this.displayerSettings.isFilterEnabled() && filterProp != null) {
            ExternalFilterRequest filterRequest = (ExternalFilterRequest)Js.cast((Object)filterProp);
            if (filterRequest.isReset()) {
                super.filterReset();
            } else {
                DataColumn column = this.dataSet.getColumnByIndex(filterRequest.getColumn());
                super.filterUpdate(column.getId(), filterRequest.getRow());
            }
            this.updateFilterStatus();
        }
    }

    public static interface View
    extends AbstractErraiDisplayer.View<ExternalComponentDisplayer> {
        public void setSize(int var1, int var2);

        public void setMargin(int var1, int var2, int var3, int var4);

        public void setFilterLabelSet(FilterLabelSet var1);
    }
}

