/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.renderer.client.selector.SelectorLabelItem;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class SelectorLabelItemView
implements SelectorLabelItem.View,
IsElement {
    @Inject
    @DataField
    Button item;
    SelectorLabelItem presenter;

    public void init(SelectorLabelItem presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setValue(String value) {
        this.item.setTextContent(value);
        this.item.setTitle(value);
    }

    @Override
    public void setDescription(String description) {
        this.item.setTitle(description);
    }

    @Override
    public void setWidth(int percentage) {
        CSSStyleDeclaration style = this.item.getStyle();
        style.setProperty("width", percentage + "%");
        style.setProperty("white-space", "nowrap");
        style.setProperty("overflow", "hidden");
        style.setProperty("text-overflow", "ellipsis");
    }

    @Override
    public void select() {
        this.item.setClassName("btn btn-primary");
    }

    @Override
    public void reset() {
        this.item.setClassName("btn btn-default");
    }

    @EventHandler(value={"item"})
    public void onItemClick(ClickEvent event) {
        this.presenter.onItemClick();
    }
}

