/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.IsWidget;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.AbstractGwtDisplayerView;
import org.dashbuilder.renderer.client.resources.i18n.SelectorConstants;
import org.dashbuilder.renderer.client.selector.SelectorDisplayer;
import org.gwtbootstrap3.client.ui.ListBox;

public class SelectorDisplayerView
extends AbstractGwtDisplayerView<SelectorDisplayer>
implements SelectorDisplayer.View {
    protected ListBox listBox = new ListBox();
    protected boolean hintEnabled = false;

    public void init(SelectorDisplayer presenter) {
        super.setPresenter((AbstractGwtDisplayer)presenter);
        super.setVisualization((IsWidget)this.listBox);
    }

    @Override
    public void showSelectHint(String column) {
        this.showHint("- " + SelectorConstants.INSTANCE.selectorDisplayer_select() + " " + column + " -");
    }

    @Override
    public void showResetHint(String column) {
        this.showHint("- " + SelectorConstants.INSTANCE.selectorDisplayer_reset() + " " + column + " -");
    }

    protected void showHint(String hint) {
        if (this.hintEnabled) {
            SelectElement selectElement = SelectElement.as((Element)this.listBox.getElement());
            NodeList options = selectElement.getOptions();
            ((OptionElement)options.getItem(0)).setText(hint);
        } else {
            this.listBox.addItem(hint);
            this.hintEnabled = true;
        }
    }

    @Override
    public void clearItems() {
        this.listBox.clear();
        this.hintEnabled = false;
    }

    @Override
    public void addItem(String id, String value, boolean selected) {
        this.listBox.addItem(value, id);
        if (selected) {
            this.listBox.setSelectedIndex(this.listBox.getItemCount() - 1);
        }
    }

    @Override
    public String getSelectedId() {
        if (this.hintEnabled && this.listBox.getSelectedIndex() == 0) {
            return null;
        }
        return this.listBox.getSelectedValue();
    }

    @Override
    public int getItemCount() {
        return this.listBox.getItemCount() - (this.hintEnabled ? 1 : 0);
    }

    @Override
    public void setItemTitle(int index, String title) {
        SelectElement selectElement = SelectElement.as((Element)this.listBox.getElement());
        NodeList options = selectElement.getOptions();
        OptionElement optionElement = (OptionElement)options.getItem(index + (this.hintEnabled ? 1 : 0));
        if (optionElement != null) {
            optionElement.setTitle(title);
        }
    }

    @Override
    public void setFilterEnabled(boolean enabled) {
        if (enabled) {
            this.listBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ((SelectorDisplayer)SelectorDisplayerView.this.getPresenter()).onItemSelected();
                }
            });
        }
    }

    @Override
    public String getGroupsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_groupsTitle();
    }

    @Override
    public String getColumnsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_columnsTitle();
    }
}

