/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class NavComponentConfigModal
implements IsWidget {
    View view;
    String groupId = null;
    NavGroup group = null;
    String defaultItemId = null;
    String targetDivId = null;
    List<NavItem> navItemList = null;
    List<String> targetDivIdList = null;
    Command onOk = null;
    Command onCancel = null;

    @Inject
    public NavComponentConfigModal(View view) {
        this.view = view;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public View getView() {
        return this.view;
    }

    public void setTargetDivIdList(List<String> targetDivIdList) {
        this.targetDivIdList = targetDivIdList;
    }

    public void setOnOk(Command onOk) {
        this.onOk = onOk;
    }

    public void setOnCancel(Command onCancel) {
        this.onCancel = onCancel;
    }

    public void setNavGroupHelpHint(String text) {
        this.view.setNavGroupHelpText(text);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDefaultItemId() {
        return this.defaultItemId;
    }

    public String getTargetDivId() {
        return this.targetDivId;
    }

    public void setTargetDivSupported(boolean supported) {
        this.view.setTargetDivVisible(supported);
    }

    public void setTargetDiv(String targetDivId) {
        this.targetDivId = targetDivId;
    }

    public void setDefaultNavItemSupported(boolean supported) {
        this.view.setDefaultNavItemVisible(supported);
    }

    public void setDefaultNavItemId(String navItemId) {
        this.defaultItemId = navItemId;
    }

    public void setNavGroup(List<NavItem> navItemList, String selectedGroupId) {
        this.navItemList = navItemList;
        this.groupId = selectedGroupId;
        this.group = null;
    }

    private void updateNavGroups() {
        this.group = null;
        this.view.clearNavGroupItems();
        if (this.navItemList != null) {
            this.updateNavGroups(this.navItemList);
        }
    }

    private void updateNavGroups(List<NavItem> navItemList) {
        navItemList.stream().filter(navItem -> navItem instanceof NavGroup).forEach(this::addNavGroup);
    }

    private void addNavGroup(NavItem navItem) {
        String fullPath = this.calculateFullPath(navItem);
        if (this.groupId == null || navItem.getId().equals(this.groupId)) {
            this.groupId = navItem.getId();
            this.group = (NavGroup)navItem;
            this.view.setNavGroupSelection(fullPath, () -> {});
        } else {
            this.view.addNavGroupItem(fullPath, () -> this.onGroupSelected(navItem.getId()));
        }
        this.updateNavGroups(((NavGroup)navItem).getChildren());
    }

    private void updateDefaultItems() {
        this.view.clearDefaultItems();
        this.view.setDefaultNavItemEnabled(this.group != null);
        if (this.group == null || this.group.getChildren().isEmpty()) {
            this.view.defaultItemsNotFound();
        } else {
            NavGroup clone = (NavGroup)this.group.cloneItem();
            clone.setParent(null);
            this.updateDefaultItems(clone, 1);
        }
    }

    private void updateDefaultItems(NavGroup navGroup, int level) {
        for (NavItem navItem : navGroup.getChildren()) {
            if (navItem instanceof NavDivider) continue;
            if (!(navItem instanceof NavGroup)) {
                String fullPath = this.calculateFullPath(navItem);
                if (this.defaultItemId != null && navItem.getId().equals(this.defaultItemId)) {
                    this.view.setDefaultItemSelection(fullPath, () -> this.onDefaultItemSelected(null));
                } else {
                    this.view.addDefaultItem(fullPath, () -> this.onDefaultItemSelected(navItem.getId()));
                }
            }
            if (!(navItem instanceof NavGroup)) continue;
            this.updateDefaultItems((NavGroup)navItem, level + 1);
        }
    }

    private void updateTargetDivs() {
        this.view.clearTargetDivItems();
        if (this.targetDivIdList == null || this.targetDivIdList.isEmpty()) {
            this.view.targetDivsNotFound();
        } else {
            for (String divId : this.targetDivIdList) {
                if (this.targetDivId == null || !this.targetDivIdList.contains(this.targetDivId) || divId.equals(this.targetDivId)) {
                    this.targetDivId = divId;
                    this.view.setTargetDivSelection(divId, () -> this.onTargetDivSelected(null));
                    continue;
                }
                this.view.addTargetDivItem(divId, () -> this.onTargetDivSelected(divId));
            }
        }
    }

    public String calculateFullPath(NavItem navItem) {
        StringBuilder out = new StringBuilder();
        for (NavGroup parent = navItem.getParent(); parent != null; parent = parent.getParent()) {
            out.insert(0, parent.getName() + ">");
        }
        out.append(navItem.getName());
        return out.toString();
    }

    public void clear() {
        this.groupId = null;
        this.group = null;
        this.defaultItemId = null;
        this.targetDivId = null;
        this.navItemList = null;
        this.targetDivIdList = null;
        this.view.clearNavGroupItems();
        this.view.clearDefaultItems();
        this.view.clearTargetDivItems();
    }

    public void show() {
        this.updateNavGroups();
        this.updateDefaultItems();
        this.updateTargetDivs();
        this.view.show();
    }

    public void onGroupSelected(String id) {
        this.groupId = id;
        this.defaultItemId = null;
        this.updateNavGroups();
        this.updateDefaultItems();
    }

    public void onDefaultItemSelected(String id) {
        this.defaultItemId = id;
        this.updateDefaultItems();
    }

    public void onTargetDivSelected(String id) {
        this.targetDivId = id;
        this.updateTargetDivs();
    }

    public void onOk() {
        if (this.groupId != null) {
            this.view.hide();
            if (this.onOk != null) {
                this.onOk.execute();
            }
        }
    }

    public void onCancel() {
        this.view.hide();
        if (this.onCancel != null) {
            this.onCancel.execute();
        }
    }

    public static interface View
    extends UberView<NavComponentConfigModal> {
        public void clearNavGroupItems();

        public void setNavGroupEnabled(boolean var1);

        public void addNavGroupItem(String var1, Command var2);

        public void setNavGroupSelection(String var1, Command var2);

        public void setNavGroupHelpText(String var1);

        public void setDefaultNavItemEnabled(boolean var1);

        public void setDefaultNavItemVisible(boolean var1);

        public void clearDefaultItems();

        public void defaultItemsNotFound();

        public void setDefaultItemSelection(String var1, Command var2);

        public void addDefaultItem(String var1, Command var2);

        public void setTargetDivVisible(boolean var1);

        public void clearTargetDivItems();

        public void targetDivsNotFound();

        public void addTargetDivItem(String var1, Command var2);

        public void setTargetDivSelection(String var1, Command var2);

        public void show();

        public void hide();
    }
}

