/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.navigation.NavItem;

public class NavItemEditorSettings {
    private int maxLevels = -1;
    private String literalGroup = "Group";
    private String literalPerspective = "Perspective";
    private String literalDivider = "Divider";
    private boolean newDividerEnabled = true;
    private boolean newGroupEnabled = true;
    private boolean newPerspectiveEnabled = true;
    private boolean gotoPerspectiveEnabled = false;
    private boolean perspectiveContextEnabled = true;
    private boolean onlyRuntimePerspectives = true;
    private Map<String, Integer> maxLevelsMap = new HashMap<String, Integer>();
    private Map<String, Flags> flagsMap = new HashMap<String, Flags>();

    public void setLiteralGroup(String literalGroup) {
        this.literalGroup = literalGroup;
    }

    public void setLiteralPerspective(String literalPerspective) {
        this.literalPerspective = literalPerspective;
    }

    public void setLiteralDivider(String literalDivider) {
        this.literalDivider = literalDivider;
    }

    public String getLiteralGroup() {
        return this.literalGroup;
    }

    public String getLiteralPerspective() {
        return this.literalPerspective;
    }

    public String getLiteralDivider() {
        return this.literalDivider;
    }

    private Flags setNavItemPropertyEnabled(String navItemId, String prop, boolean enabled) {
        Flags config = this.flagsMap.get(navItemId);
        if (config == null) {
            config = new Flags();
            this.flagsMap.put(navItemId, config);
        }
        config.setFlag(prop, enabled);
        return config;
    }

    private Boolean isNavItemPropertyEnabled(NavItem navItem, String prop) {
        Flags config = this.flagsMap.get(navItem.getId());
        if (config != null && config.flagMap.get(prop) != null) {
            return config.flagMap.get(prop);
        }
        return this.isNavAncestorPropertyEnabled((NavItem)navItem.getParent(), prop);
    }

    private Boolean isNavAncestorPropertyEnabled(NavItem navItem, String prop) {
        if (navItem == null) {
            return null;
        }
        Flags config = this.flagsMap.get(navItem.getId());
        if (config != null && config.flagMap.get(prop) != null && config.recursiveMap.get(prop) != null && config.recursiveMap.get(prop).booleanValue()) {
            return config.flagMap.get(prop);
        }
        return this.isNavAncestorPropertyEnabled((NavItem)navItem.getParent(), prop);
    }

    public boolean isNewGroupEnabled() {
        return this.newGroupEnabled;
    }

    public NavItemEditorSettings setNewGroupEnabled(boolean newGroupEnabled) {
        this.newGroupEnabled = newGroupEnabled;
        return this;
    }

    public boolean isNewGroupEnabled(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "newGroup");
        return enabled != null ? enabled : this.newGroupEnabled;
    }

    public Flags setNewGroupEnabled(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "newGroup", enabled);
    }

    public boolean isNewPerspectiveEnabled() {
        return this.newPerspectiveEnabled;
    }

    public NavItemEditorSettings setNewPerspectiveEnabled(boolean newPerspectiveEnabled) {
        this.newPerspectiveEnabled = newPerspectiveEnabled;
        return this;
    }

    public boolean isNewPerspectiveEnabled(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "newPerspective");
        return enabled != null ? enabled : this.newPerspectiveEnabled;
    }

    public Flags setNewPerspectiveEnabled(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "newPerspective", enabled);
    }

    public boolean isNewDividerEnabled() {
        return this.newDividerEnabled;
    }

    public NavItemEditorSettings setNewDividerEnabled(boolean newDividerEnabled) {
        this.newDividerEnabled = newDividerEnabled;
        return this;
    }

    public boolean isNewDividerEnabled(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "newDivider");
        return enabled != null ? enabled : this.newDividerEnabled;
    }

    public Flags setNewDividerEnabled(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "newDivider", enabled);
    }

    public boolean onlyRuntimePerspectives(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "onlyRuntimePerspectives");
        return enabled != null ? enabled : this.onlyRuntimePerspectives;
    }

    public Flags setOnlyRuntimePerspectives(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "onlyRuntimePerspectives", enabled);
    }

    public boolean isGotoPerspectiveEnabled() {
        return this.gotoPerspectiveEnabled;
    }

    public NavItemEditorSettings setGotoPerspectiveEnabled(boolean gotoPerspectiveEnabled) {
        this.gotoPerspectiveEnabled = gotoPerspectiveEnabled;
        return this;
    }

    public boolean isGotoPerspectiveEnabled(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "gotoPerspective");
        return enabled != null ? enabled : this.gotoPerspectiveEnabled;
    }

    public Flags setGotoPerspectiveEnabled(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "gotoPerspective", enabled);
    }

    public boolean isPerspectiveContextEnabled() {
        return this.perspectiveContextEnabled;
    }

    public NavItemEditorSettings setPerspectiveContextEnabled(boolean perspectiveContextEnabled) {
        this.perspectiveContextEnabled = perspectiveContextEnabled;
        return this;
    }

    public boolean isPerspectiveContextEnabled(NavItem navItem) {
        Boolean enabled = this.isNavItemPropertyEnabled(navItem, "perspectiveContext");
        return enabled != null ? enabled : this.perspectiveContextEnabled;
    }

    public Flags setPerspectiveContextEnabled(String navItemId, boolean enabled) {
        return this.setNavItemPropertyEnabled(navItemId, "perspectiveContext", enabled);
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public NavItemEditorSettings setMaxLevels(String navItemId, int maxLevels) {
        this.maxLevelsMap.put(navItemId, maxLevels);
        return this;
    }

    public int getMaxLevels(String navItemId) {
        if (!this.maxLevelsMap.containsKey(navItemId)) {
            return -1;
        }
        return this.maxLevelsMap.get(navItemId);
    }

    public NavItemEditorSettings setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
        return this;
    }

    public boolean isOnlyRuntimePerspectives() {
        return this.onlyRuntimePerspectives;
    }

    public NavItemEditorSettings setOnlyRuntimePerspectives(boolean onlyRuntimePerspectives) {
        this.onlyRuntimePerspectives = onlyRuntimePerspectives;
        return this;
    }

    public class Flags {
        public static final String NEW_GROUP = "newGroup";
        public static final String NEW_PERSPECTIVE = "newPerspective";
        public static final String NEW_DIVIDER = "newDivider";
        public static final String ONLY_RUNTIME_PERSPECTIVES = "onlyRuntimePerspectives";
        public static final String GOTO_PERSPECTIVE = "gotoPerspective";
        public static final String PERSPECTIVE_CONTEXT = "perspectiveContext";
        Map<String, Boolean> flagMap = new HashMap<String, Boolean>();
        Map<String, Boolean> recursiveMap = new HashMap<String, Boolean>();
        String lastProp = null;

        void setFlag(String prop, boolean enabled) {
            this.flagMap.put(prop, enabled);
            this.lastProp = prop;
        }

        boolean isEnabled(String prop) {
            if (this.flagMap.containsKey(prop)) {
                return this.flagMap.get(prop);
            }
            return false;
        }

        public void applyToAllChildren() {
            if (this.lastProp != null) {
                this.recursiveMap.put(this.lastProp, true);
            }
        }
    }
}

