/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.workbench;

import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class NavSecurityController {
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public NavSecurityController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public NavTree secure(NavTree navTree, boolean removeEmptyGroups) {
        NavTree clone = navTree.cloneTree();
        this.secure(clone.getRootItems(), removeEmptyGroups);
        return clone;
    }

    public void secure(List<NavItem> itemList, boolean removeEmptyGroups) {
        Iterator<NavItem> it = itemList.iterator();
        while (it.hasNext()) {
            NavItem navItem = it.next();
            if (!this.canRead(navItem)) {
                it.remove();
                continue;
            }
            if (!(navItem instanceof NavGroup)) continue;
            List<NavItem> children = ((NavGroup)navItem).getChildren();
            if (removeEmptyGroups) {
                this.removeEmptyGroups(children);
            }
            this.secure(children, removeEmptyGroups);
        }
        if (removeEmptyGroups) {
            this.removeEmptyGroups(itemList);
        }
    }

    private void removeEmptyGroups(List<NavItem> itemList) {
        Iterator<NavItem> it = itemList.iterator();
        while (it.hasNext()) {
            NavItem navItem = it.next();
            if (!(navItem instanceof NavGroup) || !this.isEmpty((NavGroup)navItem)) continue;
            it.remove();
        }
    }

    private boolean isEmpty(NavGroup navGroup) {
        for (NavItem navItem : navGroup.getChildren()) {
            if (!(navItem instanceof NavGroup ? !this.isEmpty((NavGroup)navItem) : !(navItem instanceof NavDivider))) continue;
            return false;
        }
        return true;
    }

    public boolean canRead(String navItemCtx) {
        ResourceRef resourceRef;
        NavWorkbenchCtx ctx = NavWorkbenchCtx.get(navItemCtx);
        for (String p : ctx.getPermissions()) {
            if (this.authorizationManager.authorize(p, this.user)) continue;
            return false;
        }
        String resourceId = ctx.getResourceId();
        ActivityResourceType resourceType = ctx.getResourceType();
        return resourceId == null || resourceType == null || this.authorizationManager.authorize((Resource)(resourceRef = new ResourceRef(resourceId, (ResourceType)resourceType)), this.user);
    }

    public boolean canRead(NavItem navItem) {
        if (navItem == null) {
            return false;
        }
        return this.canRead(navItem.getContext());
    }
}

