/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NavTreeTest {
    public static final String ITEM_HOME_ID = "home";
    public static final String ITEM_ADMIN_ID = "admin";
    public static final String ITEM_SECURITY_ID = "security";
    public static final String ITEM_DATASETS_ID = "datasets";
    public static final String NONEXISTENT_ITEM_ID = "item with this id does not exist";
    NavTree tree;

    @Before
    public void setUp() {
        this.tree = new NavTreeBuilder().item(ITEM_HOME_ID, "Home", null, false).divider().group(ITEM_ADMIN_ID, "Administration", null, false).item(ITEM_SECURITY_ID, "Security", null, false).item(ITEM_DATASETS_ID, "Data sets", null, false).build();
    }

    @Test
    public void testTreeStructure() {
        List rootNavItems = this.tree.getRootItems();
        Assert.assertEquals((long)rootNavItems.size(), (long)3L);
        NavItem home = this.tree.getItemById(ITEM_HOME_ID);
        Assert.assertTrue((boolean)(home instanceof NavItem));
        Assert.assertEquals((Object)home.getId(), (Object)ITEM_HOME_ID);
        Assert.assertEquals((Object)home.getName(), (Object)"Home");
        Assert.assertEquals((Object)home.isModifiable(), (Object)false);
        Assert.assertNull((Object)home.getParent());
        NavItem admin = this.tree.getItemById(ITEM_ADMIN_ID);
        Assert.assertTrue((boolean)(admin instanceof NavGroup));
        Assert.assertEquals((long)((NavGroup)admin).getChildren().size(), (long)2L);
        NavItem security = this.tree.getItemById(ITEM_SECURITY_ID);
        Assert.assertTrue((boolean)(security instanceof NavItem));
        Assert.assertEquals((Object)security.getParent(), (Object)admin);
    }

    @Test
    public void testDeleteItem() {
        this.tree.deleteItem(ITEM_HOME_ID);
        List rootNavItems = this.tree.getRootItems();
        Assert.assertEquals((long)rootNavItems.size(), (long)2L);
        this.tree.deleteItem(ITEM_DATASETS_ID);
        NavItem admin = this.tree.getItemById(ITEM_ADMIN_ID);
        Assert.assertEquals((long)((NavGroup)admin).getChildren().size(), (long)1L);
    }

    @Test(expected=RuntimeException.class)
    public void testParentNotFound() {
        this.tree.moveItem("none", "parent");
    }

    @Test(expected=RuntimeException.class)
    public void testAvoidLoops() {
        this.tree.moveItem(ITEM_HOME_ID, ITEM_HOME_ID);
    }

    @Test
    public void testItemContext() {
        this.tree.setItemContext(ITEM_HOME_ID, "p1");
        NavItem home = this.tree.getItemById(ITEM_HOME_ID);
        Assert.assertTrue((boolean)(home instanceof NavItem));
        Assert.assertEquals((Object)home.getContext(), (Object)"p1");
    }

    @Test
    public void testSearchItems() {
        NavItemContext ctx1 = NavItemContext.create().setProperty("p1", "v1").setProperty("p2", "v2");
        NavItemContext ctx2 = NavItemContext.create().setProperty("p1", "v1").setProperty("p3", "v3");
        NavItemContext ctx3 = NavItemContext.create().setProperty("p1", "v1").setProperty("p2", "v2");
        this.tree.setItemContext(ITEM_HOME_ID, ctx1.toString());
        this.tree.setItemContext(ITEM_DATASETS_ID, ctx2.toString());
        List navItems = this.tree.searchItems(ctx3);
        Assert.assertEquals((long)navItems.size(), (long)1L);
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_HOME_ID);
    }

    @Test(expected=RuntimeException.class)
    public void testMoveUpNotAllowed() {
        this.tree.moveItemUp(ITEM_SECURITY_ID);
        this.tree.moveItemDown(ITEM_DATASETS_ID);
    }

    @Test(expected=RuntimeException.class)
    public void testMoveDownNotAllowed() {
        this.tree.moveItemDown(ITEM_DATASETS_ID);
    }

    @Test
    public void testMoveUpAndDown() {
        NavGroup admin = (NavGroup)this.tree.getItemById(ITEM_ADMIN_ID);
        List navItems = admin.getChildren();
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_SECURITY_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(1)).getId(), (Object)ITEM_DATASETS_ID);
        this.tree.moveItemUp(ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(1)).getId(), (Object)ITEM_SECURITY_ID);
        this.tree.moveItemDown(ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_SECURITY_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(1)).getId(), (Object)ITEM_DATASETS_ID);
        this.tree.moveItemFirst(ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(1)).getId(), (Object)ITEM_SECURITY_ID);
        this.tree.moveItemLast(ITEM_DATASETS_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(0)).getId(), (Object)ITEM_SECURITY_ID);
        Assert.assertEquals((Object)((NavItem)navItems.get(1)).getId(), (Object)ITEM_DATASETS_ID);
    }

    @Test
    public void testSubtreeCreation() {
        NavTree subtree = this.tree.getItemAsTree(ITEM_ADMIN_ID);
        Assert.assertEquals((long)subtree.getRootItems().size(), (long)2L);
        subtree.getRootItems().forEach(i -> Assert.assertNull((Object)i.getParent()));
    }

    @Test
    public void testCloneTree() {
        NavTree clone = this.tree.cloneTree();
        clone.getRootItems().forEach(i -> Assert.assertNull((Object)i.getParent()));
    }

    @Test
    public void setItemName_worksWhenItemPresent() {
        NavItem modifiedItem = this.tree.setItemName(ITEM_HOME_ID, "NEW NAME!");
        Assert.assertEquals((Object)"NEW NAME!", (Object)modifiedItem.getName());
        Assert.assertEquals((Object)"NEW NAME!", (Object)this.tree.getItemById(ITEM_HOME_ID).getName());
    }

    @Test
    public void setItemModifiable_worksWhenItemPresent() {
        Assert.assertFalse((boolean)this.tree.getItemById(ITEM_HOME_ID).isModifiable());
        NavItem modifiedItem = this.tree.setItemModifiable(ITEM_HOME_ID, true);
        Assert.assertTrue((boolean)modifiedItem.isModifiable());
        Assert.assertTrue((boolean)this.tree.getItemById(ITEM_HOME_ID).isModifiable());
    }

    @Test
    public void setItemDescription_worksWhenItemPresent() {
        NavItem modifiedItem = this.tree.setItemDescription(ITEM_HOME_ID, "new description");
        Assert.assertEquals((Object)"new description", (Object)modifiedItem.getDescription());
        Assert.assertEquals((Object)"new description", (Object)this.tree.getItemById(ITEM_HOME_ID).getDescription());
    }

    @Test(expected=RuntimeException.class)
    public void setItemName_throwsExceptionWhenItemNotPresent() {
        this.tree.setItemName(NONEXISTENT_ITEM_ID, "anything");
    }

    @Test(expected=RuntimeException.class)
    public void setItemModifiable_throwsExceptionWhenItemNotPresent() {
        this.tree.setItemModifiable(NONEXISTENT_ITEM_ID, true);
    }

    @Test(expected=RuntimeException.class)
    public void setItemDescription_throwsExceptionWhenItemNotPresent() {
        this.tree.setItemDescription(NONEXISTENT_ITEM_ID, "doesn't matter");
    }

    @Test
    public void addGroupTest() {
        String id = "id";
        String name = "name";
        String description = "desc";
        String parentId = ITEM_ADMIN_ID;
        boolean modifiable = false;
        this.tree.addGroup("id", "name", "desc", ITEM_ADMIN_ID, false);
        NavItem newGroup = this.tree.getItemById("id");
        Assert.assertEquals((Object)"id", (Object)newGroup.getId());
        Assert.assertEquals((Object)"name", (Object)newGroup.getName());
        Assert.assertEquals((Object)ITEM_ADMIN_ID, (Object)newGroup.getParent().getId());
        Assert.assertEquals((Object)"desc", (Object)newGroup.getDescription());
        Assert.assertFalse((boolean)newGroup.isModifiable());
    }

    @Test
    public void addGroupThrowsException_whenParentIsNotGroup() {
        String idOfParentWhichIsNotGroup = ITEM_SECURITY_ID;
        try {
            this.tree.addGroup(null, null, null, idOfParentWhichIsNotGroup, true);
            Assertions.fail((String)"Exception should be thrown when using something else as parent than NavGroup");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Parent '" + idOfParentWhichIsNotGroup + "' is not a group"), (Object)e.getMessage());
        }
    }

    @Test
    public void addItemTest() {
        String id = "id";
        String name = "name";
        String description = "desc";
        String parentId = ITEM_ADMIN_ID;
        String context = "a=1";
        boolean modifiable = false;
        this.tree.addItem("id", "name", "desc", ITEM_ADMIN_ID, false, "a=1");
        NavItem item = this.tree.getItemById("id");
        Assert.assertEquals((Object)"id", (Object)item.getId());
        Assert.assertEquals((Object)"name", (Object)item.getName());
        Assert.assertEquals((Object)ITEM_ADMIN_ID, (Object)item.getParent().getId());
        Assert.assertEquals((Object)"desc", (Object)item.getDescription());
        Assert.assertFalse((boolean)item.isModifiable());
        Assert.assertEquals((Object)"a=1", (Object)item.getContext());
    }

    @Test
    public void addItemShouldThrowException_whenParentDoesNotExist() {
        try {
            this.tree.addItem(null, null, null, NONEXISTENT_ITEM_ID, true, null);
            Assertions.fail((String)"Exception should be thrown when parent with given ID does not exist");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Parent 'item with this id does not exist' not found", (Object)e.getMessage());
        }
    }

    @Test
    public void moveItemTest() {
        String newGroupId = "ngi";
        this.tree.addGroup("ngi", "name", "desc", ITEM_ADMIN_ID, true);
        this.tree.moveItem(ITEM_SECURITY_ID, "ngi");
        Assert.assertEquals((Object)"ngi", (Object)this.tree.getItemById(ITEM_SECURITY_ID).getParent().getId());
    }

    @Test
    public void moveItemShouldThrowException_whenParentDoesNotExist() {
        try {
            this.tree.moveItem(ITEM_SECURITY_ID, NONEXISTENT_ITEM_ID);
            Assertions.fail((String)"Exception should be thrown when parent with given ID does not exist");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Parent not found: item with this id does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void moveItemShouldThrowException_whenParentIdSameAsItemId() {
        String sameId = ITEM_ADMIN_ID;
        try {
            this.tree.moveItem(ITEM_ADMIN_ID, ITEM_ADMIN_ID);
            Assertions.fail((String)"Exception should be thrown when parentId same as item Id");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"The parent can't be the item itself: admin", (Object)e.getMessage());
        }
    }
}

