/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation;

import org.dashbuilder.json.JsonObject;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.json.NavTreeJSONMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class NavTreeJsonTest {
    public static final NavTree NAV_TREE = new NavTreeBuilder().item("1", "name1", "desc1", true, "ctx1").item("2", "name2", "desc2", false, "ctx2").divider().group("3", "name3", "desc3", true).item("4", "name4", "desc4", true, "ctx4").build();

    @Test
    public void testNavTreeMarshalling() {
        NavTreeJSONMarshaller jsonMarshaller = NavTreeJSONMarshaller.get();
        JsonObject _jsonObj = jsonMarshaller.toJson(NAV_TREE);
        Assert.assertNotNull((Object)_jsonObj.toString());
        NavTree navTree = jsonMarshaller.fromJson(_jsonObj);
        Assert.assertEquals((long)navTree.getRootItems().size(), (long)4L);
        NavItem navItem = navTree.getItemById("1");
        Assert.assertNotNull((Object)navItem);
        Assert.assertEquals((Object)navItem.getType(), (Object)NavItem.Type.ITEM);
        Assert.assertEquals((Object)navItem.getName(), (Object)"name1");
        Assert.assertEquals((Object)navItem.getDescription(), (Object)"desc1");
        Assert.assertEquals((Object)navItem.isModifiable(), (Object)true);
        Assert.assertEquals((Object)navItem.getContext(), (Object)"ctx1");
        navItem = navTree.getItemById("2");
        Assert.assertNotNull((Object)navItem);
        Assert.assertEquals((Object)navItem.getType(), (Object)NavItem.Type.ITEM);
        Assert.assertEquals((Object)navItem.getName(), (Object)"name2");
        Assert.assertEquals((Object)navItem.getDescription(), (Object)"desc2");
        Assert.assertEquals((Object)navItem.isModifiable(), (Object)false);
        Assert.assertEquals((Object)navItem.getContext(), (Object)"ctx2");
        navItem = navTree.getItemById("3");
        Assert.assertNotNull((Object)navItem);
        Assert.assertEquals((Object)navItem.getType(), (Object)NavItem.Type.GROUP);
        Assert.assertEquals((Object)navItem.getName(), (Object)"name3");
        Assert.assertEquals((Object)navItem.getDescription(), (Object)"desc3");
        Assert.assertEquals((Object)navItem.isModifiable(), (Object)true);
        navItem = navTree.getItemById("4");
        Assert.assertNotNull((Object)navItem);
        Assert.assertEquals((Object)navItem.getType(), (Object)NavItem.Type.ITEM);
        Assert.assertEquals((Object)navItem.getName(), (Object)"name4");
        Assert.assertEquals((Object)navItem.getDescription(), (Object)"desc4");
        Assert.assertEquals((Object)navItem.isModifiable(), (Object)true);
        Assert.assertEquals((Object)navItem.getContext(), (Object)"ctx4");
        Assert.assertEquals((Object)navItem.getParent(), (Object)navTree.getItemById("3"));
    }
}

