/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.workbench.NavSecurityController;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class NavSecurityTest {
    public static final String ITEM_HOME_ID = "home";
    public static final String ITEM_ADMIN_ID = "admin";
    public static final String ITEM_SECURITY_ID = "security";
    public static final String ITEM_DATASETS_ID = "datasets";
    @Mock
    AuthorizationManager authorizationManager;
    @Mock
    User user;
    NavTree tree;
    NavSecurityController controller;

    @Before
    public void setUp() {
        this.tree = new NavTreeBuilder().item(ITEM_HOME_ID, "Home", null, false, (NavItemContext)NavWorkbenchCtx.permission((String[])new String[]{ITEM_HOME_ID})).divider().group(ITEM_ADMIN_ID, "Administration", null, false).item(ITEM_SECURITY_ID, "Security", null, false, (NavItemContext)NavWorkbenchCtx.permission((String[])new String[]{ITEM_SECURITY_ID})).item(ITEM_DATASETS_ID, "Data sets", null, false, (NavItemContext)NavWorkbenchCtx.permission((String[])new String[]{ITEM_DATASETS_ID})).build();
        this.controller = new NavSecurityController(this.authorizationManager, this.user);
    }

    @Test
    public void testTreeStructure() {
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_HOME_ID, this.user)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_SECURITY_ID, this.user)).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_DATASETS_ID, this.user)).thenReturn((Object)true);
        NavTree securedTree = this.controller.secure(this.tree, true);
        List rootNavItems = securedTree.getRootItems();
        Assert.assertEquals((long)rootNavItems.size(), (long)3L);
        NavItem admin = securedTree.getItemById(ITEM_ADMIN_ID);
        Assert.assertTrue((boolean)(admin instanceof NavGroup));
        Assert.assertEquals((long)((NavGroup)admin).getChildren().size(), (long)1L);
    }

    @Test
    public void testHideEmptyGroups() {
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_HOME_ID, this.user)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_SECURITY_ID, this.user)).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationManager.authorize(ITEM_DATASETS_ID, this.user)).thenReturn((Object)false);
        NavTree securedTree = this.controller.secure(this.tree, true);
        NavItem admin = securedTree.getItemById(ITEM_ADMIN_ID);
        Assert.assertEquals((long)securedTree.getRootItems().size(), (long)2L);
        Assert.assertNull((Object)admin);
        ArrayList navItems = new ArrayList(this.tree.getRootItems());
        this.controller.secure(navItems, true);
        Assert.assertEquals((long)navItems.size(), (long)2L);
    }
}

