/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.workbench.model.ActivityResourceType;

public class NavItemContextTest {
    @Test
    public void testEmpty() {
        NavItemContext ctx = NavItemContext.get((String)"");
        Assert.assertEquals((long)ctx.getPropertyIds().size(), (long)0L);
        ctx = NavItemContext.create();
        Assert.assertEquals((long)ctx.getPropertyIds().size(), (long)0L);
    }

    @Test
    public void testParse() {
        NavItemContext ctx = NavItemContext.get((String)"a=A;b=B;");
        Assert.assertEquals((long)ctx.getPropertyIds().size(), (long)2L);
        Assert.assertEquals((Object)ctx.getProperty("a"), (Object)"A");
        Assert.assertEquals((Object)ctx.getProperty("b"), (Object)"B");
    }

    @Test
    public void testFormat() {
        NavItemContext ctx = NavItemContext.create();
        ctx.setProperty("a", "A");
        ctx.setProperty("b", "B");
        Assert.assertEquals((long)ctx.getPropertyIds().size(), (long)2L);
        Assert.assertEquals((Object)ctx.getProperty("a"), (Object)"A");
        Assert.assertEquals((Object)ctx.getProperty("b"), (Object)"B");
        Assert.assertEquals((Object)ctx.toString(), (Object)"a=A;b=B;");
    }

    @Test
    public void testPerspective() {
        NavWorkbenchCtx ctx = NavWorkbenchCtx.perspective((String)"A");
        Assert.assertEquals((long)ctx.getPropertyIds().size(), (long)2L);
        Assert.assertEquals((Object)ctx.getResourceId(), (Object)"A");
        Assert.assertEquals((Object)ctx.getResourceType(), (Object)ActivityResourceType.PERSPECTIVE);
        Assert.assertEquals((Object)ctx.getProperty("resourceId"), (Object)"A");
        Assert.assertEquals((Object)ctx.getProperty("resourceType"), (Object)"PERSPECTIVE");
        Assert.assertEquals((Object)ctx.toString(), (Object)"resourceId=A;resourceType=PERSPECTIVE;");
    }

    @Test
    public void testPermissions() {
        NavWorkbenchCtx ctx = NavWorkbenchCtx.permission((String[])new String[]{"p1", "p2", "p3"});
        ((ListAssert)Assertions.assertThat((List)ctx.getPermissions()).hasSize(3)).contains((Object[])new String[]{"p1", "p2", "p3"});
        ctx.clearPermissions();
        Assertions.assertThat((List)ctx.getPermissions()).isEmpty();
    }

    @Test
    public void testRemoveProperty() {
        NavWorkbenchCtx ctx = NavWorkbenchCtx.get((String)"a=1;b=2;c=3");
        ctx.removeProperty("b");
        NavWorkbenchCtx expectedCtx = NavWorkbenchCtx.get((String)"a=1;c=3");
        Assert.assertTrue((boolean)ctx.includesPropertiesOf((NavItemContext)expectedCtx));
    }
}

