/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation;

import java.util.Arrays;
import java.util.Collection;
import org.dashbuilder.navigation.NavItemContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NavItemContextInclusionTest {
    @Parameterized.Parameter(value=0)
    public String ctx1;
    @Parameterized.Parameter(value=1)
    public String ctx2;
    @Parameterized.Parameter(value=2)
    public boolean includesPropertiesOf;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"", "", true}, {"a=1", "a=1", true}, {"a=1;b=2", "a=1;b=2", true}, {"a=1;b=2", "b=2;a=1", true}, {"a=1;b=2", "a=1", true}, {"a=1;b=2;c=3", "b=2", true}, {"a=1;b=2", "c=3", false}, {"a=1", "a=2", false}, {"a=1;b=2", "a=1;c=2", false}, {"A=1", "a=1", false});
    }

    @Test
    public void testMatch() {
        NavItemContext c1 = NavItemContext.get((String)this.ctx1);
        NavItemContext c2 = NavItemContext.get((String)this.ctx2);
        String msg = String.format("NavItemContext %s should%s include properties of  %s", this.ctx1, this.includesPropertiesOf ? "" : " not", this.ctx2);
        Assert.assertEquals((String)msg, (Object)this.includesPropertiesOf, (Object)c1.includesPropertiesOf(c2));
    }
}

