/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import org.dashbuilder.client.editor.DisplayerDragComponent;
import org.dashbuilder.client.editor.PerspectiveEditorReportingGroupProvider;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;

@RunWith(value=GwtMockitoTestRunner.class)
public class PerspectiveEditorReportingGroupProviderTest {
    @Mock
    RendererManager rendererManager;
    @Mock
    SyncBeanManager beanManager;
    @InjectMocks
    PerspectiveEditorReportingGroupProvider perspectiveEditorReportingGroupProvider;
    @Mock
    RendererLibrary rendererLibrary;
    @Mock
    SyncBeanDef<DisplayerDragComponent> displayerDragComponentBeanDef;
    @Mock
    DisplayerDragComponent displayerDragComponent;

    @Before
    public void setUp() {
        Mockito.when((Object)this.beanManager.lookupBean((Class)Matchers.any(DisplayerDragComponent.class.getClass()), new Annotation[0])).thenReturn(this.displayerDragComponentBeanDef);
        Mockito.when((Object)this.displayerDragComponentBeanDef.getInstance()).thenReturn((Object)this.displayerDragComponent);
    }

    @Test
    public void groupShouldBeEmptyWhenTheresNoRendererTest() {
        LayoutDragComponentGroup componentGroup = this.perspectiveEditorReportingGroupProvider.getComponentGroup();
        Assert.assertTrue((boolean)componentGroup.getLayoutDragComponentIds().isEmpty());
    }

    @Test
    public void groupShouldHaveNComponentWhenTheresRendererTest() {
        Mockito.when((Object)this.rendererManager.isTypeSupported(DisplayerType.BARCHART)).thenReturn((Object)true);
        Mockito.when((Object)this.rendererManager.isTypeSupported(DisplayerType.LINECHART)).thenReturn((Object)true);
        LayoutDragComponentGroup componentGroup = this.perspectiveEditorReportingGroupProvider.getComponentGroup();
        Assert.assertEquals((long)componentGroup.getLayoutDragComponentIds().size(), (long)2L);
    }
}

