/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client.engine;

import com.google.gwt.core.client.Duration;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.CommonConstants;
import org.dashbuilder.dataset.engine.Chronometer;

@Dependent
public final class ClientChronometer
implements Chronometer {
    protected Double startTime;
    protected Double stopTime;

    public long start() {
        this.stopTime = null;
        this.startTime = Duration.currentTimeMillis();
        return this.startTime.longValue() * 1000000L;
    }

    public long stop() {
        this.stopTime = Duration.currentTimeMillis();
        return this.stopTime.longValue() * 1000000L;
    }

    public long elapsedTime() {
        long stop = this.stopTime != null ? this.stopTime.longValue() : System.currentTimeMillis();
        return (stop - this.startTime.longValue()) * 1000000L;
    }

    public String formatElapsedTime(long millis) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        days %= 7L;
        double secondsd = (double)(seconds * 1000L + milliseconds) / 1000.0;
        StringBuilder buf = new StringBuilder();
        if (weeks > 0L) {
            buf.append(weeks).append(" ").append(CommonConstants.INSTANCE.weeks()).append(" ");
        }
        if (days > 0L) {
            buf.append(days).append("d ");
        }
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (minutes > 0L) {
            buf.append(minutes).append("m ");
        }
        if (secondsd > 0.0) {
            buf.append(secondsd).append("s");
        }
        if (buf.length() == 0) {
            return "0s";
        }
        return buf.toString();
    }
}

