/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.service.DataSetLookupServices;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetClientServicesTest {
    @Mock
    private ClientDataSetManager clientDataSetManager;
    @Mock
    private DataSetMetadata dataSetMetadata;
    @Mock
    private DataSetLookupServices dataSetLookupServices;
    private CallerMock<DataSetLookupServices> dataSetLookupServicesCallerMock;
    private boolean isCallbackCalled = false;
    private boolean isNotFoundCalled = false;
    private boolean isOnErrorCalled = false;

    @Before
    public void setup() {
        this.dataSetLookupServicesCallerMock = new CallerMock((Object)this.dataSetLookupServices);
    }

    @Test
    public void testFetchMetadataWhenMetadataIsNotNull() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, this.dataSetLookupServicesCallerMock);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn((Object)this.dataSetMetadata);
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertTrue((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertNull(services.getRemoteMetadataMap().get("uuid"));
    }

    @Test
    public void testFetchMetadataWhenSetLookupServicesIsNull() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, null);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn(null);
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertFalse((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertTrue((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertNull(services.getRemoteMetadataMap().get("uuid"));
    }

    @Test
    public void testFetchMetadataWhenRemoteMetadataMapContainsTheUUID() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, this.dataSetLookupServicesCallerMock);
        services.getRemoteMetadataMap().put("uuid", null);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn(null);
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertTrue((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertNull(services.getRemoteMetadataMap().get("uuid"));
    }

    @Test
    public void testFetchMetadataWhenResultIsNull() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, this.dataSetLookupServicesCallerMock);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn(null);
        Mockito.when((Object)this.dataSetLookupServices.lookupDataSetMetadata((String)Mockito.eq((Object)"uuid"))).thenReturn(null);
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertFalse((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertTrue((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertNull(services.getRemoteMetadataMap().get("uuid"));
    }

    @Test
    public void testFetchMetadataWhenResultIsNotNull() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, this.dataSetLookupServicesCallerMock);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn(null);
        Mockito.when((Object)this.dataSetLookupServices.lookupDataSetMetadata((String)Mockito.eq((Object)"uuid"))).thenReturn((Object)this.dataSetMetadata);
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertTrue((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertEquals(services.getRemoteMetadataMap().get("uuid"), (Object)this.dataSetMetadata);
    }

    @Test
    public void testFetchMetadataWhenDataSetLookupServicesReturnsAnError() throws Exception {
        String uuid = "uuid";
        DataSetClientServices services = this.makeDataSetClientServices(this.clientDataSetManager, this.dataSetLookupServicesCallerMock);
        Mockito.when((Object)this.clientDataSetManager.getDataSetMetadata("uuid")).thenReturn(null);
        ((DataSetLookupServices)Mockito.doThrow(Exception.class).when((Object)this.dataSetLookupServices)).lookupDataSetMetadata((String)Mockito.any());
        services.fetchMetadata("uuid", this.makeDataSetMetadataCallback());
        Assert.assertFalse((boolean)this.isDataSetMetadataCallbackCalled());
        Assert.assertFalse((boolean)this.isDataSetMetadataNotFoundCallbackCalled());
        Assert.assertTrue((boolean)this.isDataSetMetadataOnErrorCallbackCalled());
        Assert.assertNull(services.getRemoteMetadataMap().get("uuid"));
    }

    private DataSetMetadataCallback makeDataSetMetadataCallback() {
        return new DataSetMetadataCallback(){

            public void callback(DataSetMetadata metadata) {
                DataSetClientServicesTest.this.callbackCalled();
            }

            public void notFound() {
                DataSetClientServicesTest.this.notFoundCalled();
            }

            public boolean onError(ClientRuntimeError error) {
                DataSetClientServicesTest.this.onErrorCalled();
                return false;
            }
        };
    }

    private void onErrorCalled() {
        this.isOnErrorCalled = true;
    }

    private void notFoundCalled() {
        this.isNotFoundCalled = true;
    }

    private void callbackCalled() {
        this.isCallbackCalled = true;
    }

    public boolean isDataSetMetadataCallbackCalled() {
        return this.isCallbackCalled;
    }

    public boolean isDataSetMetadataNotFoundCallbackCalled() {
        return this.isNotFoundCalled;
    }

    public boolean isDataSetMetadataOnErrorCallbackCalled() {
        return this.isOnErrorCalled;
    }

    private DataSetClientServices makeDataSetClientServices(ClientDataSetManager clientDataSetManager, CallerMock<DataSetLookupServices> dataSetLookupServicesCallerMock) {
        return new DataSetClientServices(clientDataSetManager, null, null, null, null, null, null, dataSetLookupServicesCallerMock, null, null);
    }
}

