/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import javax.enterprise.event.Event;
import org.dashbuilder.common.client.backend.PathUrlFactory;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.ExpenseReportsData;
import org.dashbuilder.dataset.client.ChronometerMock;
import org.dashbuilder.dataset.client.ClientDataSetCore;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.ClientDateFormatterMock;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.engine.ClientDateFormatter;
import org.dashbuilder.dataset.engine.Chronometer;
import org.dashbuilder.dataset.events.DataSetModifiedEvent;
import org.dashbuilder.dataset.events.DataSetPushOkEvent;
import org.dashbuilder.dataset.events.DataSetPushingEvent;
import org.dashbuilder.dataset.service.DataSetDefServices;
import org.dashbuilder.dataset.service.DataSetExportServices;
import org.dashbuilder.dataset.service.DataSetLookupServices;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.mockito.Mock;
import org.uberfire.mocks.CallerMock;

public abstract class AbstractDataSetTest {
    @Mock
    protected Event<DataSetPushingEvent> dataSetPushingEvent;
    @Mock
    protected Event<DataSetPushOkEvent> dataSetPushOkEvent;
    @Mock
    protected Event<DataSetModifiedEvent> dataSetModifiedEvent;
    @Mock
    protected DataSetLookupServices dataSetLookupServices;
    @Mock
    protected DataSetExportServices dataSetExportServices;
    @Mock
    protected PathUrlFactory pathUrlFactory;
    @Mock
    protected Caller<DataSetDefServices> dataSetDefServicesCaller;
    protected Caller<DataSetExportServices> dataSetExportServicesCaller;
    protected Caller<DataSetLookupServices> dataSetLookupServicesCaller;
    protected ClientDataSetCore clientDataSetCore;
    protected DataSetClientServices clientServices;
    protected ClientDataSetManager clientDataSetManager;
    protected DataSet expensesDataSet;
    protected DataSetFormatter dataSetFormatter = new DataSetFormatter();
    public static final String EXPENSES = "expenses";

    public void initClientFactory() {
        this.clientDataSetCore = ClientDataSetCore.get();
        this.clientDataSetCore.setClientDateFormatter((ClientDateFormatter)new ClientDateFormatterMock());
        this.clientDataSetCore.setChronometer((Chronometer)new ChronometerMock());
    }

    public void initClientDataSetManager() {
        this.clientDataSetManager = this.clientDataSetCore.getClientDataSetManager();
    }

    public void initDataSetClientServices() {
        this.dataSetExportServicesCaller = new CallerMock((Object)this.dataSetExportServices);
        this.dataSetLookupServicesCaller = new CallerMock((Object)this.dataSetLookupServices);
        this.clientServices = new DataSetClientServices(this.clientDataSetManager, this.pathUrlFactory, this.clientDataSetCore.getAggregateFunctionManager(), this.clientDataSetCore.getIntervalBuilderLocator(), this.dataSetPushingEvent, this.dataSetPushOkEvent, this.dataSetModifiedEvent, this.dataSetLookupServicesCaller, this.dataSetDefServicesCaller, this.dataSetExportServicesCaller);
    }

    public void registerExpensesDataSet() throws Exception {
        this.expensesDataSet = ExpenseReportsData.INSTANCE.toDataSet();
        this.expensesDataSet.setUUID(EXPENSES);
        this.clientDataSetManager.registerDataSet(this.expensesDataSet);
    }

    @Before
    public void init() throws Exception {
        this.initClientFactory();
        this.initClientDataSetManager();
        this.initDataSetClientServices();
        this.registerExpensesDataSet();
    }

    public void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

