/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.win.amd64;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SequenceLayout;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.cryptomator.jfuse.api.DirFiller;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseConnInfo;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.Statvfs;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.win.amd64.DirFillerImpl;
import org.cryptomator.jfuse.win.amd64.FileInfoImpl;
import org.cryptomator.jfuse.win.amd64.FuseConnInfoImpl;
import org.cryptomator.jfuse.win.amd64.StatImpl;
import org.cryptomator.jfuse.win.amd64.StatvfsImpl;
import org.cryptomator.jfuse.win.amd64.TimeSpecImpl;
import org.cryptomator.jfuse.win.amd64.extr.fuse_context;
import org.cryptomator.jfuse.win.amd64.extr.fuse_h;
import org.cryptomator.jfuse.win.amd64.extr.fuse_operations;
import org.cryptomator.jfuse.win.amd64.extr.fuse_timespec;

public final class FuseImpl
extends Fuse {
    private final CompletableFuture<Integer> initialized = new CompletableFuture();
    private final FuseOperations delegate;
    private final MemorySegment struct = fuse_operations.allocate((SegmentAllocator)this.fuseScope);
    private final AtomicReference<MemoryAddress> fuseHandle;

    public FuseImpl(FuseOperations fuseOperations) {
        this.delegate = fuseOperations;
        fuse_operations.init$set(this.struct, fuse_operations.init.allocate(this::init, this.fuseScope).address());
        fuseOperations.supportedOperations().forEach(this::bind);
        this.fuseHandle = new AtomicReference();
    }

    private MemoryAddress init(MemoryAddress conn) {
        try (MemorySession scope = MemorySession.openConfined();){
            if (this.delegate.supportedOperations().contains(FuseOperations.Operation.INIT)) {
                this.delegate.init((FuseConnInfo)new FuseConnInfoImpl(conn, scope));
            }
            MemorySegment ctx = fuse_context.ofAddress(fuse_h.fuse_get_context(), scope);
            this.fuseHandle.set(fuse_context.fuse$get(ctx));
            this.initialized.complete(0);
        }
        catch (Exception e) {
            this.initialized.completeExceptionally(e);
        }
        return MemoryAddress.NULL;
    }

    public int mount(String progName, Path mountPoint, String ... flags) throws TimeoutException {
        Path adjustedMP = mountPoint;
        if (mountPoint.compareTo(mountPoint.getRoot()) == 0 && mountPoint.isAbsolute()) {
            adjustedMP = Path.of(mountPoint.toString().charAt(0) + ":", new String[0]);
        }
        return super.mount(progName, adjustedMP, flags);
    }

    protected CompletableFuture<Integer> initialized() {
        return this.initialized;
    }

    protected int fuseMain(int argc, MemorySegment argv) {
        return fuse_h.fuse_main_real(argc, (Addressable)argv, (Addressable)this.struct, this.struct.byteSize(), (Addressable)MemoryAddress.NULL);
    }

    private void fuseExit() {
        MemoryAddress actualHandle = this.fuseHandle.getAndSet(null);
        if (actualHandle != null) {
            fuse_h.fuse_exit((Addressable)actualHandle);
        }
    }

    private void bind(FuseOperations.Operation operation) {
        switch (operation) {
            case INIT: {
                break;
            }
            case ACCESS: {
                fuse_operations.access$set(this.struct, fuse_operations.access.allocate(this::access, this.fuseScope).address());
                break;
            }
            case CHMOD: {
                fuse_operations.chmod$set(this.struct, fuse_operations.chmod.allocate(this::chmod, this.fuseScope).address());
                break;
            }
            case CREATE: {
                fuse_operations.create$set(this.struct, fuse_operations.create.allocate(this::create, this.fuseScope).address());
                break;
            }
            case DESTROY: {
                fuse_operations.destroy$set(this.struct, fuse_operations.destroy.allocate(this::destroy, this.fuseScope).address());
                break;
            }
            case GET_ATTR: {
                fuse_operations.getattr$set(this.struct, fuse_operations.getattr.allocate(this::getattr, this.fuseScope).address());
                break;
            }
            case MKDIR: {
                fuse_operations.mkdir$set(this.struct, fuse_operations.mkdir.allocate(this::mkdir, this.fuseScope).address());
                break;
            }
            case OPEN: {
                fuse_operations.open$set(this.struct, fuse_operations.open.allocate(this::open, this.fuseScope).address());
                break;
            }
            case OPEN_DIR: {
                fuse_operations.opendir$set(this.struct, fuse_operations.opendir.allocate(this::opendir, this.fuseScope).address());
                break;
            }
            case READ: {
                fuse_operations.read$set(this.struct, fuse_operations.read.allocate(this::read, this.fuseScope).address());
                break;
            }
            case READ_DIR: {
                fuse_operations.readdir$set(this.struct, fuse_operations.readdir.allocate(this::readdir, this.fuseScope).address());
                break;
            }
            case READLINK: {
                fuse_operations.readlink$set(this.struct, fuse_operations.readlink.allocate(this::readlink, this.fuseScope).address());
                break;
            }
            case RELEASE: {
                fuse_operations.release$set(this.struct, fuse_operations.release.allocate(this::release, this.fuseScope).address());
                break;
            }
            case RELEASE_DIR: {
                fuse_operations.releasedir$set(this.struct, fuse_operations.releasedir.allocate(this::releasedir, this.fuseScope).address());
                break;
            }
            case RENAME: {
                fuse_operations.rename$set(this.struct, fuse_operations.rename.allocate(this::rename, this.fuseScope).address());
                break;
            }
            case RMDIR: {
                fuse_operations.rmdir$set(this.struct, fuse_operations.rmdir.allocate(this::rmdir, this.fuseScope).address());
                break;
            }
            case STATFS: {
                fuse_operations.statfs$set(this.struct, fuse_operations.statfs.allocate(this::statfs, this.fuseScope).address());
                break;
            }
            case SYMLINK: {
                fuse_operations.symlink$set(this.struct, fuse_operations.symlink.allocate(this::symlink, this.fuseScope).address());
                break;
            }
            case TRUNCATE: {
                fuse_operations.truncate$set(this.struct, fuse_operations.truncate.allocate(this::truncate, this.fuseScope).address());
                break;
            }
            case UNLINK: {
                fuse_operations.unlink$set(this.struct, fuse_operations.unlink.allocate(this::unlink, this.fuseScope).address());
                break;
            }
            case UTIMENS: {
                fuse_operations.utimens$set(this.struct, fuse_operations.utimens.allocate(this::utimens, this.fuseScope).address());
                break;
            }
            case WRITE: {
                fuse_operations.write$set(this.struct, fuse_operations.write.allocate(this::write, this.fuseScope).address());
            }
        }
    }

    private int access(MemoryAddress path, int mask) {
        return this.delegate.access(path.getUtf8String(0L), mask);
    }

    private int chmod(MemoryAddress path, int mode) {
        return this.delegate.chmod(path.getUtf8String(0L), mode);
    }

    private int create(MemoryAddress path, int mode, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.create(path.getUtf8String(0L), mode, (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private void destroy(MemoryAddress addr) {
        this.delegate.destroy();
    }

    private int getattr(MemoryAddress path, MemoryAddress stat) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.getattr(path.getUtf8String(0L), (Stat)new StatImpl(stat, scope));
            return n;
        }
    }

    private int mkdir(MemoryAddress path, int mode) {
        return this.delegate.mkdir(path.getUtf8String(0L), mode);
    }

    private int open(MemoryAddress path, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.open(path.getUtf8String(0L), (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int opendir(MemoryAddress path, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.opendir(path.getUtf8String(0L), (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int read(MemoryAddress path, MemoryAddress buf, long size, long offset, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            ByteBuffer buffer = MemorySegment.ofAddress((MemoryAddress)buf, (long)size, (MemorySession)scope).asByteBuffer();
            int n = this.delegate.read(path.getUtf8String(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int readdir(MemoryAddress path, MemoryAddress buf, MemoryAddress filler, long offset, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.readdir(path.getUtf8String(0L), (DirFiller)new DirFillerImpl(buf, filler, scope), offset, (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int readlink(MemoryAddress path, MemoryAddress buf, long len) {
        try (MemorySession scope = MemorySession.openConfined();){
            ByteBuffer buffer = MemorySegment.ofAddress((MemoryAddress)buf, (long)len, (MemorySession)scope).asByteBuffer();
            int n = this.delegate.readlink(path.getUtf8String(0L), buffer, len);
            return n;
        }
    }

    private int release(MemoryAddress path, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.release(path.getUtf8String(0L), (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int releasedir(MemoryAddress path, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.releasedir(path.getUtf8String(0L), (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    private int rename(MemoryAddress oldpath, MemoryAddress newpath) {
        return this.delegate.rename(oldpath.getUtf8String(0L), newpath.getUtf8String(0L));
    }

    private int rmdir(MemoryAddress path) {
        return this.delegate.rmdir(path.getUtf8String(0L));
    }

    private int statfs(MemoryAddress path, MemoryAddress statvfs) {
        try (MemorySession scope = MemorySession.openConfined();){
            int n = this.delegate.statfs(path.getUtf8String(0L), (Statvfs)new StatvfsImpl(statvfs, scope));
            return n;
        }
    }

    private int symlink(MemoryAddress linkname, MemoryAddress target) {
        return this.delegate.symlink(linkname.getUtf8String(0L), target.getUtf8String(0L));
    }

    private int truncate(MemoryAddress path, long size) {
        return this.delegate.truncate(path.getUtf8String(0L), size);
    }

    private int unlink(MemoryAddress path) {
        return this.delegate.unlink(path.getUtf8String(0L));
    }

    private int utimens(MemoryAddress path, MemoryAddress times) {
        if (MemoryAddress.NULL.equals((Object)times)) {
            MemorySegment segment = MemorySegment.ofBuffer(ByteBuffer.allocate((int)fuse_timespec.$LAYOUT().byteSize()));
            fuse_timespec.tv_sec$set(segment, 0L);
            fuse_timespec.tv_nsec$set(segment, 0L);
            TimeSpecImpl time = new TimeSpecImpl(segment);
            return this.delegate.utimens(path.getUtf8String(0L), (TimeSpec)time, (TimeSpec)time);
        }
        try (MemorySession scope = MemorySession.openConfined();){
            SequenceLayout seq = MemoryLayout.sequenceLayout(2L, fuse_timespec.$LAYOUT());
            MemorySegment segment = MemorySegment.ofAddress((MemoryAddress)times, (long)seq.byteSize(), (MemorySession)scope);
            MemorySegment time0 = segment.asSlice(0L, fuse_timespec.$LAYOUT().byteSize());
            MemorySegment time1 = segment.asSlice(fuse_timespec.$LAYOUT().byteSize(), fuse_timespec.$LAYOUT().byteSize());
            int n = this.delegate.utimens(path.getUtf8String(0L), (TimeSpec)new TimeSpecImpl(time0), (TimeSpec)new TimeSpecImpl(time1));
            return n;
        }
    }

    private int write(MemoryAddress path, MemoryAddress buf, long size, long offset, MemoryAddress fi) {
        try (MemorySession scope = MemorySession.openConfined();){
            ByteBuffer buffer = MemorySegment.ofAddress((MemoryAddress)buf, (long)size, (MemorySession)scope).asByteBuffer();
            int n = this.delegate.write(path.getUtf8String(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi, scope));
            return n;
        }
    }

    public void close() throws TimeoutException {
        this.fuseExit();
        super.close();
    }
}

