/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.win.amd64;

import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.win.amd64.TimeSpecImpl;
import org.cryptomator.jfuse.win.amd64.extr.fuse_stat;

record StatImpl(MemorySegment segment) implements Stat
{
    private static final int S_IFDIR = 16384;
    private static final int S_IFREG = 32768;
    private static final int S_IFLNK = 40960;

    public StatImpl(MemoryAddress address, ResourceScope scope) {
        this(fuse_stat.ofAddress(address, scope));
    }

    public TimeSpec aTime() {
        return new TimeSpecImpl(fuse_stat.st_atim$slice(this.segment));
    }

    public TimeSpec cTime() {
        return new TimeSpecImpl(fuse_stat.st_ctim$slice(this.segment));
    }

    public TimeSpec mTime() {
        return new TimeSpecImpl(fuse_stat.st_mtim$slice(this.segment));
    }

    public TimeSpec birthTime() {
        return new TimeSpecImpl(fuse_stat.st_birthtim$slice(this.segment));
    }

    public void setMode(int mode) {
        fuse_stat.st_mode$set(this.segment, mode);
    }

    public int getMode() {
        return fuse_stat.st_mode$get(this.segment);
    }

    public void setNLink(short count) {
        fuse_stat.st_nlink$set(this.segment, count);
    }

    public long getNLink() {
        return fuse_stat.st_nlink$get(this.segment);
    }

    public void setSize(long size) {
        fuse_stat.st_size$set(this.segment, size);
    }

    public long getSize() {
        return fuse_stat.st_size$get(this.segment);
    }

    public boolean isDir() {
        return (this.getMode() & 0x4000) == 16384;
    }

    public void toggleDir(boolean isDir) {
        if (isDir) {
            this.setMode(this.getMode() | 0x4000);
        } else {
            this.setMode(this.getMode() & 0xFFFFBFFF);
        }
    }

    public boolean isReg() {
        return (this.getMode() & 0x8000) == 32768;
    }

    public void toggleReg(boolean isReg) {
        if (isReg) {
            this.setMode(this.getMode() | 0x8000);
        } else {
            this.setMode(this.getMode() & 0xFFFF7FFF);
        }
    }

    public boolean isLnk() {
        return (this.getMode() & 0xA000) == 40960;
    }

    public void toggleLnk(boolean isLnk) {
        if (isLnk) {
            this.setMode(this.getMode() | 0xA000);
        } else {
            this.setMode(this.getMode() & 0xFFFF5FFF);
        }
    }
}

