/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.win.amd64;

import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Set;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.win.amd64.extr.fcntl_h;
import org.cryptomator.jfuse.win.amd64.extr.fuse_file_info;

record FileInfoImpl(MemorySegment segment) implements FileInfo
{
    public FileInfoImpl(MemoryAddress address, ResourceScope scope) {
        this(fuse_file_info.ofAddress(address, scope));
    }

    public long getFh() {
        return fuse_file_info.fh$get(this.segment);
    }

    public void setFh(long fh) {
        fuse_file_info.fh$set(this.segment, fh);
    }

    public int getFlags() {
        return fuse_file_info.flags$get(this.segment);
    }

    public Set<StandardOpenOption> getOpenFlags() {
        EnumSet<StandardOpenOption> result = EnumSet.noneOf(StandardOpenOption.class);
        int read2 = fcntl_h.O_RDONLY() | fcntl_h.O_RDWR();
        int write2 = fcntl_h.O_WRONLY() | fcntl_h.O_RDWR();
        int createNew = fcntl_h.O_WRONLY() | fcntl_h.O_EXCL();
        int flags = this.getFlags();
        if ((flags & read2) != 0) {
            result.add(StandardOpenOption.READ);
        }
        if ((flags & write2) != 0) {
            result.add(StandardOpenOption.WRITE);
        }
        if ((flags & fcntl_h.O_APPEND()) != 0) {
            result.add(StandardOpenOption.APPEND);
        }
        if ((flags & fcntl_h.O_CREAT()) != 0) {
            result.add(StandardOpenOption.CREATE);
        }
        if ((flags & createNew) != 0) {
            result.add(StandardOpenOption.CREATE_NEW);
        }
        if ((flags & fcntl_h.O_TRUNC()) != 0) {
            result.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        return result;
    }

    public long getLockOwner() {
        return fuse_file_info.lock_owner$get(this.segment);
    }
}

