/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.Quota;
import org.cryptomator.cloudaccess.api.exceptions.AlreadyExistsException;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.api.exceptions.CloudTimeoutException;
import org.cryptomator.cloudaccess.api.exceptions.InsufficientStorageException;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;
import org.cryptomator.cloudaccess.api.exceptions.ParentFolderDoesNotExistException;
import org.cryptomator.cloudaccess.api.exceptions.TypeMismatchException;
import org.cryptomator.cloudaccess.webdav.ForbiddenException;
import org.cryptomator.cloudaccess.webdav.InputStreamRequestBody;
import org.cryptomator.cloudaccess.webdav.ProgressRequestWrapper;
import org.cryptomator.cloudaccess.webdav.ProgressResponseWrapper;
import org.cryptomator.cloudaccess.webdav.PropfindEntryItemData;
import org.cryptomator.cloudaccess.webdav.PropfindResponseParser;
import org.cryptomator.cloudaccess.webdav.ServerNotWebdavCompatibleException;
import org.cryptomator.cloudaccess.webdav.UnauthorizedException;
import org.cryptomator.cloudaccess.webdav.WebDavCompatibleHttpClient;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;
import org.cryptomator.cloudaccess.webdav.WebDavProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class WebDavClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebDavClient.class);
    private static final Comparator<PropfindEntryItemData> ASCENDING_BY_DEPTH = Comparator.comparingLong(PropfindEntryItemData::getDepth);
    private final WebDavCompatibleHttpClient httpClient;
    private final URL baseUrl;
    private final int HTTP_INSUFFICIENT_STORAGE = 507;

    WebDavClient(WebDavCompatibleHttpClient httpClient, WebDavCredential webDavCredential) {
        this.httpClient = httpClient;
        this.baseUrl = webDavCredential.getBaseUrl();
    }

    CloudItemMetadata itemMetadata(CloudPath path) throws CloudProviderException {
        CloudItemMetadata cloudItemMetadata;
        block9: {
            LOG.trace("itemMetadata {}", (Object)path);
            Response response = this.executePropfindRequest(path, PropfindDepth.ZERO);
            try {
                this.checkPropfindExecutionSucceeded(response.code());
                cloudItemMetadata = this.processGet(this.getEntriesFromResponse(response), path);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedIOException e) {
                    throw new CloudTimeoutException(e);
                }
                catch (IOException | SAXException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudItemMetadata;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Quota quota(CloudPath folder) throws CloudProviderException {
        LOG.trace("quota {}", (Object)folder);
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:quota-available-bytes/>\n<d:quota-used-bytes/>\n</d:prop>\n</d:propfind>";
        Request.Builder builder = new Request.Builder().method("PROPFIND", RequestBody.create((String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:quota-available-bytes/>\n<d:quota-used-bytes/>\n</d:prop>\n</d:propfind>", (MediaType)MediaType.parse((String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:quota-available-bytes/>\n<d:quota-used-bytes/>\n</d:prop>\n</d:propfind>"))).url(this.absoluteURLFrom(folder)).header("Depth", PropfindDepth.ZERO.value).header("Content-Type", "text/xml");
        try (Response response = this.httpClient.execute(builder);){
            Quota quota;
            block15: {
                this.checkPropfindExecutionSucceeded(response.code());
                ResponseBody responseBody = response.body();
                try {
                    quota = new PropfindResponseParser().parseQuta(responseBody.byteStream());
                    if (responseBody == null) break block15;
                }
                catch (Throwable throwable) {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                responseBody.close();
            }
            return quota;
        }
        catch (InterruptedIOException e) {
            throw new CloudTimeoutException(e);
        }
        catch (IOException | SAXException e) {
            throw new CloudProviderException(e);
        }
    }

    CloudItemList list(CloudPath folder) throws CloudProviderException {
        CloudItemList cloudItemList;
        block9: {
            LOG.trace("list {}", (Object)folder);
            Response response = this.executePropfindRequest(folder, PropfindDepth.ONE);
            try {
                this.checkPropfindExecutionSucceeded(response.code());
                List<PropfindEntryItemData> nodes = this.getEntriesFromResponse(response);
                cloudItemList = this.processDirList(nodes, folder);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedIOException e) {
                    throw new CloudTimeoutException(e);
                }
                catch (IOException | SAXException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudItemList;
    }

    private void checkPropfindExecutionSucceeded(int responseCode) {
        switch (responseCode) {
            case 401: {
                throw new UnauthorizedException();
            }
            case 403: {
                throw new ForbiddenException();
            }
            case 404: {
                throw new NotFoundException();
            }
        }
        if (responseCode < 199 || responseCode > 300) {
            throw new CloudProviderException("Response code isn't between 200 and 300: " + responseCode);
        }
    }

    private Response executePropfindRequest(CloudPath path, PropfindDepth propfindDepth) throws IOException {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>";
        Request.Builder builder = new Request.Builder().method("PROPFIND", RequestBody.create((String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>", (MediaType)MediaType.parse((String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>"))).url(this.absoluteURLFrom(path)).header("Depth", propfindDepth.value).header("Content-Type", "text/xml");
        return this.httpClient.execute(builder);
    }

    private List<PropfindEntryItemData> getEntriesFromResponse(Response response) throws IOException, SAXException {
        try (ResponseBody responseBody = response.body();){
            List<PropfindEntryItemData> list = new PropfindResponseParser().parseItemData(responseBody.byteStream());
            return list;
        }
    }

    private CloudItemMetadata processGet(List<PropfindEntryItemData> entryData, CloudPath path) {
        entryData.sort(ASCENDING_BY_DEPTH);
        return entryData.size() >= 1 ? this.toCloudItem(entryData.get(0), path) : null;
    }

    private CloudItemList processDirList(List<PropfindEntryItemData> entryData, CloudPath folder) {
        CloudItemList result = new CloudItemList(new ArrayList<CloudItemMetadata>());
        if (entryData.isEmpty()) {
            return result;
        }
        entryData.sort(ASCENDING_BY_DEPTH);
        for (PropfindEntryItemData childEntry : entryData.subList(1, entryData.size())) {
            result = result.add(List.of(this.toCloudItem(childEntry, folder.resolve(childEntry.getName()))));
        }
        return result;
    }

    private CloudItemMetadata toCloudItem(PropfindEntryItemData data, CloudPath path) {
        if (data.isCollection()) {
            return new CloudItemMetadata(data.getName(), path, CloudItemType.FOLDER);
        }
        return new CloudItemMetadata(data.getName(), path, CloudItemType.FILE, data.getLastModified(), data.getSize());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CloudPath move(CloudPath from, CloudPath to, boolean replace) throws CloudProviderException {
        LOG.trace("move {} to {} (replace: {})", new Object[]{from, to, replace ? "true" : "false"});
        Request.Builder builder = new Request.Builder().method("MOVE", null).url(this.absoluteURLFrom(from)).header("Destination", this.absoluteURLFrom(to).toExternalForm()).header("Content-Type", "text/xml").header("Depth", "infinity");
        if (!replace) {
            builder.header("Overwrite", "F");
        }
        try (Response response = this.httpClient.execute(builder);){
            if (response.isSuccessful()) {
                CloudPath cloudPath = to;
                return cloudPath;
            }
            switch (response.code()) {
                case 401: {
                    throw new UnauthorizedException();
                }
                case 403: {
                    throw new ForbiddenException();
                }
                case 404: {
                    throw new NotFoundException();
                }
                case 409: {
                    throw new ParentFolderDoesNotExistException();
                }
                case 412: {
                    throw new AlreadyExistsException(this.absoluteURLFrom(to).toExternalForm());
                }
                case 507: {
                    throw new InsufficientStorageException();
                }
            }
            throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
        }
        catch (InterruptedIOException e) {
            throw new CloudTimeoutException(e);
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    InputStream read(CloudPath path, ProgressListener progressListener) throws CloudProviderException {
        LOG.trace("read {}", (Object)path);
        Request.Builder getRequest = new Request.Builder().get().url(this.absoluteURLFrom(path));
        return this.read(getRequest, progressListener);
    }

    InputStream read(CloudPath path, long offset, long count, ProgressListener progressListener) throws CloudProviderException {
        LOG.trace("read {} (offset: {}, count: {})", new Object[]{path, offset, count});
        Request.Builder getRequest = new Request.Builder().header("Range", String.format("bytes=%d-%d", offset, offset + count - 1L)).get().url(this.absoluteURLFrom(path));
        return this.read(getRequest, progressListener);
    }

    private InputStream read(Request.Builder getRequest, ProgressListener progressListener) throws CloudProviderException {
        Response response = null;
        boolean success = false;
        try {
            response = this.httpClient.execute(getRequest);
            ProgressResponseWrapper countingBody = new ProgressResponseWrapper(response.body(), progressListener);
            if (response.isSuccessful()) {
                success = true;
                InputStream inputStream = countingBody.byteStream();
                return inputStream;
            }
            switch (response.code()) {
                case 401: {
                    throw new UnauthorizedException();
                }
                case 403: {
                    throw new ForbiddenException();
                }
                case 404: {
                    throw new NotFoundException();
                }
                case 416: {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                    return byteArrayInputStream;
                }
            }
            try {
                throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
            }
            catch (InterruptedIOException e) {
                throw new CloudTimeoutException(e);
            }
            catch (IOException e) {
                throw new CloudProviderException(e);
            }
        }
        finally {
            if (response != null && !success) {
                response.close();
            }
        }
    }

    void write(CloudPath file, boolean replace, InputStream data, long size, Optional<Instant> lastModified, ProgressListener progressListener) throws CloudProviderException {
        LOG.trace("write {} (size: {}, lastModified: {}, replace: {})", new Object[]{file, size, lastModified, replace ? "true" : "false"});
        if (!replace && this.exists(file)) {
            throw new AlreadyExistsException("CloudNode already exists and replace is false");
        }
        ProgressRequestWrapper countingBody = new ProgressRequestWrapper(InputStreamRequestBody.from(data, size), progressListener);
        Request.Builder requestBuilder = new Request.Builder().url(this.absoluteURLFrom(file)).put((RequestBody)countingBody);
        lastModified.ifPresent(instant -> requestBuilder.addHeader("X-OC-Mtime", String.valueOf(instant.getEpochSecond())));
        try (Response response = this.httpClient.execute(requestBuilder);){
            if (!response.isSuccessful()) {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedException();
                    }
                    case 403: {
                        throw new ForbiddenException();
                    }
                    case 405: {
                        throw new TypeMismatchException();
                    }
                    case 404: 
                    case 409: {
                        throw new ParentFolderDoesNotExistException();
                    }
                    case 507: {
                        throw new InsufficientStorageException();
                    }
                }
                throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
            }
        }
        catch (InterruptedIOException e) {
            throw new CloudTimeoutException(e);
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    private boolean exists(CloudPath path) throws CloudProviderException {
        try {
            return this.itemMetadata(path) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CloudPath createFolder(CloudPath path) throws CloudProviderException {
        LOG.trace("createFolder {}", (Object)path);
        Request.Builder builder = new Request.Builder().method("MKCOL", null).url(this.absoluteURLFrom(path));
        try (Response response = this.httpClient.execute(builder);){
            if (response.isSuccessful()) {
                CloudPath cloudPath = path;
                return cloudPath;
            }
            switch (response.code()) {
                case 401: {
                    throw new UnauthorizedException();
                }
                case 403: {
                    throw new ForbiddenException();
                }
                case 405: {
                    throw new AlreadyExistsException(String.format("Folder %s already exists", path.toString()));
                }
                case 409: {
                    throw new ParentFolderDoesNotExistException();
                }
                case 507: {
                    throw new InsufficientStorageException();
                }
            }
            throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
        }
        catch (InterruptedIOException e) {
            throw new CloudTimeoutException(e);
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    void delete(CloudPath path) throws CloudProviderException {
        LOG.trace("delete {}", (Object)path);
        Request.Builder builder = new Request.Builder().delete().url(this.absoluteURLFrom(path));
        try (Response response = this.httpClient.execute(builder);){
            if (!response.isSuccessful()) {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedException();
                    }
                    case 403: {
                        throw new ForbiddenException();
                    }
                    case 404: {
                        throw new NotFoundException(String.format("Node %s doesn't exists", path.toString()));
                    }
                }
                throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
            }
        }
        catch (InterruptedIOException e) {
            throw new CloudTimeoutException(e);
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    void checkServerCompatibility() throws ServerNotWebdavCompatibleException {
        block14: {
            LOG.trace("checkServerCompatibility");
            Request.Builder optionsRequest = new Request.Builder().method("OPTIONS", null).url(this.baseUrl);
            try (Response response = this.httpClient.execute(optionsRequest);){
                if (response.isSuccessful()) {
                    boolean containsDavHeader = response.headers().names().contains("DAV");
                    if (!containsDavHeader) {
                        throw new ServerNotWebdavCompatibleException();
                    }
                    break block14;
                }
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedException();
                    }
                    case 403: {
                        throw new ForbiddenException();
                    }
                }
                throw new CloudProviderException("Response code isn't between 200 and 300: " + response.code());
            }
            catch (IOException e) {
                throw new CloudProviderException(e);
            }
        }
    }

    void tryAuthenticatedRequest() throws UnauthorizedException {
        LOG.trace("tryAuthenticatedRequest");
        this.itemMetadata(CloudPath.of("/", new String[0]));
    }

    URL absoluteURLFrom(CloudPath relativePath) {
        CloudPath basePath = CloudPath.of(this.baseUrl.getPath(), new String[0]).toAbsolutePath();
        CloudPath fullPath = IntStream.range(0, relativePath.getNameCount()).mapToObj(relativePath::getName).reduce(basePath, CloudPath::resolve);
        try {
            return new URL(this.baseUrl, fullPath.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The relative path contains invalid URL elements.");
        }
    }

    static class WebDavAuthenticator {
        WebDavAuthenticator() {
        }

        static WebDavClient createAuthenticatedWebDavClient(WebDavCredential webDavCredential, WebDavProviderConfig config) throws ServerNotWebdavCompatibleException, UnauthorizedException {
            WebDavClient webDavClient = new WebDavClient(new WebDavCompatibleHttpClient(webDavCredential, config), webDavCredential);
            webDavClient.checkServerCompatibility();
            webDavClient.tryAuthenticatedRequest();
            return webDavClient;
        }
    }

    private static enum PropfindDepth {
        ZERO("0"),
        ONE("1"),
        INFINITY("infinity");

        private final String value;

        private PropfindDepth(String value) {
            this.value = value;
        }
    }
}

