/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.vaultformat8;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cryptolib.api.FileHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileHeaderCache {
    private static final Logger LOG = LoggerFactory.getLogger(FileHeaderCache.class);
    private final Cache<CloudPath, FileHeader> cache;

    FileHeaderCache(int timeoutMillis) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMillis(timeoutMillis)).build();
    }

    public CompletionStage<FileHeader> get(CloudPath ciphertextPath, Function<CloudPath, CompletionStage<FileHeader>> onMiss) {
        FileHeader cached = (FileHeader)this.cache.getIfPresent((Object)ciphertextPath);
        if (cached != null) {
            LOG.trace("Cache hit for {}", (Object)ciphertextPath);
            return CompletableFuture.completedFuture(cached);
        }
        LOG.trace("Cache miss for {}", (Object)ciphertextPath);
        return onMiss.apply(ciphertextPath).thenApply(fileHeader -> {
            this.cache.put((Object)ciphertextPath, fileHeader);
            return fileHeader;
        });
    }

    public void evict(CloudPath ciphertextPath) {
        this.cache.invalidate((Object)ciphertextPath);
    }
}

