/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.api;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CloudPath
implements Comparable<CloudPath>,
Iterable<CloudPath> {
    private static final String SEPARATOR = "/";
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private final List<String> elements;
    private final boolean absolute;

    private CloudPath(boolean absolute, List<String> elements) {
        this.absolute = absolute;
        this.elements = List.copyOf(elements);
    }

    public static CloudPath of(String first, String ... more) {
        if (more == null) {
            return new CloudPath(first.startsWith(SEPARATOR), CloudPath.splitStreamAndCollect(first, new String[0]));
        }
        return new CloudPath(first.startsWith(SEPARATOR), CloudPath.splitStreamAndCollect(first, more));
    }

    List<String> getElements() {
        return this.elements;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public CloudPath getRoot() {
        return this.absolute ? CloudPath.of(SEPARATOR, new String[0]) : null;
    }

    public CloudPath getFileName() {
        int elementCount = this.getNameCount();
        if (elementCount == 0) {
            return null;
        }
        return this.getName(elementCount - 1);
    }

    public CloudPath getParent() {
        int elementCount = this.getNameCount();
        if (elementCount > 1) {
            List<String> elems = this.elements.subList(0, elementCount - 1);
            return this.copyWithElements(elems);
        }
        if (elementCount == 1) {
            return this.getRoot();
        }
        return null;
    }

    public int getNameCount() {
        return this.elements.size();
    }

    public CloudPath getName(int index) {
        return this.subpath(index, index + 1);
    }

    public CloudPath subpath(int beginIndex, int endIndex) {
        return new CloudPath(false, this.elements.subList(beginIndex, endIndex));
    }

    public boolean startsWith(CloudPath path) {
        boolean matchesAbsolute;
        boolean bl = matchesAbsolute = this.isAbsolute() == path.isAbsolute();
        if (matchesAbsolute && path.elements.size() <= this.elements.size()) {
            return this.elements.subList(0, path.elements.size()).equals(path.elements);
        }
        return false;
    }

    public boolean startsWith(String other) {
        return this.startsWith(CloudPath.of(other, new String[0]));
    }

    public boolean endsWith(CloudPath path) {
        if (path.elements.size() <= this.elements.size()) {
            return this.elements.subList(this.elements.size() - path.elements.size(), this.elements.size()).equals(path.elements);
        }
        return false;
    }

    public boolean endsWith(String other) {
        return this.endsWith(CloudPath.of(other, new String[0]));
    }

    public CloudPath normalize() {
        LinkedList<String> normalized = new LinkedList<String>();
        for (String elem : this.elements) {
            String lastElem = normalized.peekLast();
            if (elem.isEmpty() || CURRENT_DIR.equals(elem)) continue;
            if (PARENT_DIR.equals(elem) && lastElem != null && !PARENT_DIR.equals(lastElem)) {
                normalized.removeLast();
                continue;
            }
            normalized.add(elem);
        }
        return this.copyWithElements(normalized);
    }

    public CloudPath resolve(CloudPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        ArrayList<String> joined = new ArrayList<String>();
        joined.addAll(this.elements);
        joined.addAll(path.elements);
        return this.copyWithElements(joined);
    }

    public CloudPath resolve(String other) {
        return this.resolve(CloudPath.of(other, new String[0]));
    }

    public CloudPath resolveSibling(CloudPath path) {
        CloudPath parent = this.getParent();
        if (parent == null || path.isAbsolute()) {
            return path;
        }
        return parent.resolve(path);
    }

    public CloudPath resolveSibling(String other) {
        return this.resolveSibling(CloudPath.of(other, new String[0]));
    }

    public CloudPath relativize(CloudPath path) {
        CloudPath normalized = this.normalize();
        CloudPath other = path.normalize();
        if (normalized.isAbsolute() == other.isAbsolute()) {
            int commonPrefix = this.countCommonPrefixElements(normalized, other);
            int stepsUp = this.getNameCount() - commonPrefix;
            ArrayList<String> elems = new ArrayList<String>();
            elems.addAll(Collections.nCopies(stepsUp, PARENT_DIR));
            elems.addAll(other.elements.subList(commonPrefix, other.getNameCount()));
            return this.copyWithElementsAndAbsolute(elems, false);
        }
        throw new IllegalArgumentException("Can't relativize an absolute path relative to a relative path.");
    }

    private int countCommonPrefixElements(CloudPath p1, CloudPath p2) {
        int n = Math.min(p1.getNameCount(), p2.getNameCount());
        for (int i = 0; i < n; ++i) {
            if (p1.elements.get(i).equals(p2.elements.get(i))) continue;
            return i;
        }
        return n;
    }

    public CloudPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.copyWithAbsolute(true);
    }

    @Override
    public Iterator<CloudPath> iterator() {
        return new Iterator<CloudPath>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CloudPath.this.getNameCount();
            }

            @Override
            public CloudPath next() {
                return CloudPath.this.getName(this.idx++);
            }
        };
    }

    @Override
    public int compareTo(CloudPath path) {
        if (this.isAbsolute() != path.isAbsolute()) {
            return this.isAbsolute() ? -1 : 1;
        }
        for (int i = 0; i < Math.min(this.getNameCount(), path.getNameCount()); ++i) {
            int result = this.elements.get(i).compareTo(path.elements.get(i));
            if (result == 0) continue;
            return result;
        }
        return this.getNameCount() - path.getNameCount();
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + this.elements.hashCode();
        hash = 31 * hash + (this.absolute ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CloudPath) {
            CloudPath other = (CloudPath)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public String toString() {
        String prefix = this.absolute ? SEPARATOR : "";
        return prefix + String.join((CharSequence)SEPARATOR, this.elements);
    }

    private CloudPath copyWithElements(List<String> elements) {
        return new CloudPath(this.absolute, elements);
    }

    private CloudPath copyWithAbsolute(boolean absolute) {
        return new CloudPath(absolute, this.elements);
    }

    private CloudPath copyWithElementsAndAbsolute(List<String> elements, boolean absolute) {
        return new CloudPath(absolute, elements);
    }

    private static List<String> splitStreamAndCollect(String first, String ... more) {
        return Stream.concat(Splitter.on((String)SEPARATOR).splitToStream((CharSequence)first), Arrays.stream(more).flatMap(arg_0 -> ((Splitter)Splitter.on((String)SEPARATOR)).splitToStream(arg_0))).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableList());
    }
}

