/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.Quota;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;
import org.cryptomator.cloudaccess.api.exceptions.QuotaNotAvailableException;

public class MetadataCachingProviderDecorator
implements CloudProvider {
    private static final int DEFAULT_CACHE_TIMEOUT_SECONDS = 10;
    final Cache<CloudPath, CompletionStage<CloudItemMetadata>> itemMetadataCache;
    final Cache<CloudPath, CompletionStage<Quota>> quotaCache;
    private final CloudProvider delegate;

    public MetadataCachingProviderDecorator(CloudProvider delegate) {
        this(delegate, Duration.ofSeconds(Integer.getInteger("org.cryptomator.cloudaccess.metadatacachingprovider.timeoutSeconds", 10).intValue()));
    }

    public MetadataCachingProviderDecorator(CloudProvider delegate, Duration cacheEntryMaxAge) {
        this.delegate = delegate;
        this.itemMetadataCache = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryMaxAge).build();
        this.quotaCache = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryMaxAge).build();
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        try {
            return (CompletionStage)this.itemMetadataCache.get((Object)node, () -> this.delegate.itemMetadata(node).whenComplete((metadata, throwable) -> {
                if (throwable != null && !(throwable instanceof NotFoundException)) {
                    this.itemMetadataCache.invalidate((Object)node);
                }
            }));
        }
        catch (ExecutionException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletionStage<Quota> quota(CloudPath folder) {
        try {
            return (CompletionStage)this.quotaCache.get((Object)folder, () -> this.delegate.quota(folder).whenComplete((metadata, throwable) -> {
                if (throwable != null && !(throwable instanceof NotFoundException) && !(throwable instanceof QuotaNotAvailableException)) {
                    this.quotaCache.invalidate((Object)folder);
                }
            }));
        }
        catch (ExecutionException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        return this.delegate.list(folder, pageToken).whenComplete((cloudItemList, exception) -> {
            this.evictIncludingDescendants(folder);
            if (exception == null) {
                assert (cloudItemList != null);
                cloudItemList.getItems().forEach(metadata -> this.itemMetadataCache.put((Object)metadata.getPath(), CompletableFuture.completedFuture(metadata)));
            }
        });
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, ProgressListener progressListener) {
        return this.delegate.read(file, progressListener).whenComplete((metadata, exception) -> {
            if (exception != null) {
                this.itemMetadataCache.invalidate((Object)file);
            }
        });
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        return this.delegate.read(file, offset, count, progressListener).whenComplete((inputStream, exception) -> {
            if (exception != null) {
                this.itemMetadataCache.invalidate((Object)file);
            }
        });
    }

    @Override
    public CompletionStage<Void> write(CloudPath file, boolean replace, InputStream data, long size, Optional<Instant> lastModified, ProgressListener progressListener) {
        return this.delegate.write(file, replace, data, size, lastModified, progressListener).whenComplete((nullReturn, exception) -> {
            if (exception == null) {
                this.itemMetadataCache.put((Object)file, CompletableFuture.completedFuture(new CloudItemMetadata(file.getFileName().toString(), file, CloudItemType.FILE, lastModified, Optional.of(size))));
                this.quotaCache.invalidateAll();
            } else {
                this.itemMetadataCache.invalidate((Object)file);
            }
        });
    }

    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        return this.delegate.createFolder(folder).whenComplete((metadata, exception) -> {
            this.itemMetadataCache.invalidate((Object)folder);
            this.quotaCache.invalidateAll();
        });
    }

    @Override
    public CompletionStage<Void> deleteFile(CloudPath file) {
        return this.delegate.deleteFile(file).whenComplete((nullReturn, exception) -> {
            CompletableFuture future = CompletableFuture.failedFuture(new NotFoundException());
            this.itemMetadataCache.put((Object)file, future);
            this.quotaCache.invalidateAll();
        });
    }

    @Override
    public CompletionStage<Void> deleteFolder(CloudPath folder) {
        return this.delegate.deleteFolder(folder).whenComplete((nullReturn, exception) -> {
            this.evictIncludingDescendants(folder);
            CompletableFuture future = CompletableFuture.failedFuture(new NotFoundException());
            this.itemMetadataCache.put((Object)folder, future);
            this.quotaCache.invalidateAll();
        });
    }

    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        return this.delegate.move(source, target, replace).whenComplete((path, exception) -> {
            this.evictIncludingDescendants(source);
            this.evictIncludingDescendants(target);
            this.quotaCache.invalidateAll();
        });
    }

    private void evictIncludingDescendants(CloudPath cleartextPath) {
        for (CloudPath path : this.itemMetadataCache.asMap().keySet()) {
            if (!path.startsWith(cleartextPath)) continue;
            this.itemMetadataCache.invalidate((Object)path);
        }
    }
}

