/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.cryptomator.cloudaccess.api.Quota;
import org.cryptomator.cloudaccess.api.exceptions.QuotaNotAvailableException;
import org.cryptomator.cloudaccess.webdav.PropfindEntryItemData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PropfindResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(PropfindResponseParser.class);
    private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final String TAG_RESPONSE = "response";
    private static final String TAG_HREF = "href";
    private static final String TAG_COLLECTION = "collection";
    private static final String TAG_LAST_MODIFIED = "getlastmodified";
    private static final String TAG_CONTENT_LENGTH = "getcontentlength";
    private static final String TAG_QUOTA_AVAILABLE = "quota-available-bytes";
    private static final String TAG_QUOTA_USED = "quota-used-bytes";
    private static final String TAG_PROPSTAT = "propstat";
    private static final String TAG_STATUS = "status";
    private static final String STATUS_OK = "200";
    private final SAXParser parser;

    PropfindResponseParser() {
        try {
            this.parser = PARSER_FACTORY.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<PropfindEntryItemData> parseItemData(InputStream responseBody) throws SAXException, IOException {
        if (responseBody == null) {
            return List.of();
        }
        ParseItemMetadataHandler parseHandler = new ParseItemMetadataHandler();
        this.parser.parse(responseBody, (DefaultHandler)parseHandler);
        return parseHandler.entries;
    }

    public Quota parseQuta(InputStream responseBody) throws SAXException, IOException {
        if (responseBody == null) {
            return null;
        }
        ParseQuotaHandler parseHandler = new ParseQuotaHandler();
        this.parser.parse(responseBody, (DefaultHandler)parseHandler);
        return parseHandler.quota;
    }

    private Optional<Instant> parseDate(String text) {
        try {
            return Optional.of(Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(text)));
        }
        catch (DateTimeException e) {
            return Optional.empty();
        }
    }

    private Optional<Long> parseLong(String text) {
        try {
            return Optional.of(Long.parseLong(text));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    static {
        PARSER_FACTORY.setNamespaceAware(true);
    }

    private class ParseQuotaHandler
    extends DefaultHandler {
        public Quota quota;
        private StringBuilder textBuffer;
        private String quotaAvailable;
        private String quotaUsed;
        private String status;

        private ParseQuotaHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName.toLowerCase()) {
                case "response": {
                    this.status = null;
                    break;
                }
                case "quota-available-bytes": 
                case "quota-used-bytes": 
                case "status": {
                    this.textBuffer = new StringBuilder();
                    break;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.textBuffer != null) {
                this.textBuffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (localName.toLowerCase()) {
                case "propstat": {
                    this.assembleEntry();
                    break;
                }
                case "quota-available-bytes": {
                    this.quotaAvailable = this.textBuffer.toString();
                    break;
                }
                case "quota-used-bytes": {
                    this.quotaUsed = this.textBuffer.toString();
                    break;
                }
                case "status": {
                    this.status = this.textBuffer.toString();
                    break;
                }
            }
        }

        private void assembleEntry() {
            if (!this.status.contains(PropfindResponseParser.STATUS_OK)) {
                LOG.trace("No propstat element with 200 status in response element. Entry ignored.");
                return;
            }
            Optional<Long> available = PropfindResponseParser.this.parseLong(this.quotaAvailable);
            Optional<Long> used = PropfindResponseParser.this.parseLong(this.quotaUsed);
            if (available.isEmpty() || used.isEmpty()) {
                throw new QuotaNotAvailableException();
            }
            if (available.get() < 0L || used.get() < 0L) {
                throw new QuotaNotAvailableException();
            }
            this.quota = new Quota(available.get(), Optional.empty(), used);
        }
    }

    private class ParseItemMetadataHandler
    extends DefaultHandler {
        public final List<PropfindEntryItemData> entries = new ArrayList<PropfindEntryItemData>();
        private StringBuilder textBuffer;
        private String href;
        private String lastModified;
        private String contentLength;
        private String status;
        private boolean isCollection;

        private ParseItemMetadataHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName.toLowerCase()) {
                case "response": {
                    this.href = null;
                    this.lastModified = null;
                    this.contentLength = null;
                    this.status = null;
                    this.isCollection = false;
                    break;
                }
                case "href": 
                case "getlastmodified": 
                case "getcontentlength": 
                case "status": {
                    this.textBuffer = new StringBuilder();
                    break;
                }
                case "collection": {
                    this.isCollection = true;
                    break;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.textBuffer != null) {
                this.textBuffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (localName.toLowerCase()) {
                case "propstat": {
                    this.assembleEntry();
                    break;
                }
                case "href": {
                    this.href = this.textBuffer.toString();
                    break;
                }
                case "getlastmodified": {
                    this.lastModified = this.textBuffer.toString();
                    break;
                }
                case "getcontentlength": {
                    this.contentLength = this.textBuffer.toString();
                    break;
                }
                case "status": {
                    this.status = this.textBuffer.toString();
                    break;
                }
            }
        }

        private void assembleEntry() {
            if (!this.status.contains(PropfindResponseParser.STATUS_OK)) {
                LOG.trace("No propstat element with 200 status in response element. Entry ignored.");
                return;
            }
            if (this.href == null) {
                LOG.trace("Missing href in response element. Entry ignored.");
                return;
            }
            PropfindEntryItemData entry = new PropfindEntryItemData();
            entry.setLastModified(PropfindResponseParser.this.parseDate(this.lastModified));
            entry.setSize(PropfindResponseParser.this.parseLong(this.contentLength));
            entry.setPath(this.href);
            entry.setCollection(this.isCollection);
            this.entries.add(entry);
        }
    }
}

