/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.vaultformat8;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.math.LongMath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.Quota;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.vaultformat8.DirectoryIdCache;
import org.cryptomator.cloudaccess.vaultformat8.FileHeaderCache;
import org.cryptomator.cloudaccess.vaultformat8.OffsetInputStream;
import org.cryptomator.cloudaccess.vaultformat8.VaultFormat8ProviderConfig;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.DecryptingReadableByteChannel;
import org.cryptomator.cryptolib.EncryptingReadableByteChannel;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultFormat8ProviderDecorator
implements CloudProvider {
    private static final Logger LOG = LoggerFactory.getLogger(VaultFormat8ProviderDecorator.class);
    private static final String CIPHERTEXT_FILE_SUFFIX = ".c9r";
    private static final String DIR_FILE_NAME = "dir.c9r";
    private final CloudProvider delegate;
    private final CloudPath dataDir;
    private final Cryptor cryptor;
    private final DirectoryIdCache dirIdCache;
    private final FileHeaderCache fileHeaderCache;
    private final VaultFormat8ProviderConfig config;

    public VaultFormat8ProviderDecorator(CloudProvider delegate, CloudPath dataDir, Cryptor cryptor) {
        this.delegate = delegate;
        this.dataDir = dataDir;
        this.cryptor = cryptor;
        this.config = VaultFormat8ProviderConfig.createFromSystemProperties();
        this.dirIdCache = new DirectoryIdCache();
        this.fileHeaderCache = new FileHeaderCache(this.config.getFileHeaderCacheTimeoutMillis());
    }

    public void initialize() throws InterruptedException, CloudProviderException {
        try {
            CloudPath rootDirPath = this.getDirPathWithId(new byte[0]);
            assert (rootDirPath.getParent().getParent().equals(this.dataDir)) : "root dir should be dataDir/xx/yyyyyyyyyyyyyyyyyyyyyyyyyyyyyy";
            CompletionStage futureRootDir = this.delegate.createFolderIfNonExisting(this.dataDir).thenCompose(unused -> this.delegate.createFolderIfNonExisting(rootDirPath.getParent())).thenCompose(unused -> this.delegate.createFolderIfNonExisting(rootDirPath));
            futureRootDir.toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new CloudProviderException("Failed to initialize vault", e);
        }
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        if (node.getNameCount() == 0) {
            return CompletableFuture.completedFuture(new CloudItemMetadata("", node, CloudItemType.FOLDER, Optional.empty(), Optional.empty()));
        }
        CompletionStage<byte[]> futureParentDirId = this.getDirId(node.getParent());
        String cleartextName = node.getFileName().toString();
        CompletionStage<byte[]> futureCiphertextMetadata = futureParentDirId.thenApply(parentDirId -> this.getC9rPath((byte[])parentDirId, cleartextName)).thenCompose(this.delegate::itemMetadata);
        return futureCiphertextMetadata.thenCombine(futureParentDirId, (ciphertextMetadata, parentDirId) -> this.toCleartextMetadata((CloudItemMetadata)ciphertextMetadata, node.getParent(), (byte[])parentDirId));
    }

    @Override
    public CompletionStage<Quota> quota(CloudPath folder) {
        if (folder.getNameCount() == 0) {
            return this.delegate.quota(folder);
        }
        return this.getDirPathFromClearTextDir(folder).thenCompose(this.delegate::quota);
    }

    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        CompletionStage ciphertextItemList = this.getDirPathFromClearTextDir(folder).thenCompose(ciphertextPath -> this.delegate.list((CloudPath)ciphertextPath, pageToken));
        return this.getDirId(folder).thenCombine(ciphertextItemList, (dirId, itemList) -> this.toCleartextItemList((CloudItemList)itemList, folder, (byte[])dirId));
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must not be negative");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must not be negative");
        long firstChunk = offset / (long)this.cryptor.fileContentCryptor().cleartextChunkSize();
        int headerSize = this.cryptor.fileHeaderCryptor().headerSize();
        long firstByte = (long)headerSize + firstChunk * (long)this.cryptor.fileContentCryptor().ciphertextChunkSize();
        long lastByte = this.checkedAdd(offset, count, Long.MAX_VALUE);
        long lastChunk = lastByte / (long)this.cryptor.fileContentCryptor().cleartextChunkSize();
        long numChunks = lastChunk - firstChunk + 1L;
        long numBytes = this.checkedMultiply(numChunks, this.cryptor.fileContentCryptor().ciphertextChunkSize(), Long.MAX_VALUE);
        CompletionStage<CloudPath> futureCiphertextPath = this.getC9rPath(file);
        CompletionStage<InputStream> futureHeader = futureCiphertextPath.thenCompose(ciphertextPath -> this.fileHeaderCache.get((CloudPath)ciphertextPath, this::readFileHeader));
        CompletionStage futureCiphertext = futureCiphertextPath.thenCompose(ciphertextPath -> this.delegate.read((CloudPath)ciphertextPath, firstByte, numBytes, progressListener));
        CompletionStage<InputStream> futureCleartextStream = futureHeader.thenCombine(futureCiphertext, (header, ciphertext) -> {
            ReadableByteChannel ciphertextChannel = Channels.newChannel(ciphertext);
            DecryptingReadableByteChannel cleartextChannel = new DecryptingReadableByteChannel(ciphertextChannel, this.cryptor, true, header, firstChunk);
            return Channels.newInputStream((ReadableByteChannel)cleartextChannel);
        });
        return futureCleartextStream.thenApply(in -> {
            long skip = offset % (long)this.cryptor.fileContentCryptor().cleartextChunkSize();
            OffsetInputStream offsetIn = new OffsetInputStream((InputStream)in, skip);
            InputStream limitedIn = ByteStreams.limit((InputStream)offsetIn, (long)count);
            return limitedIn;
        });
    }

    private long checkedMultiply(long a, long b, long onOverflow) {
        try {
            return LongMath.checkedMultiply((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            return onOverflow;
        }
    }

    private long checkedAdd(long a, long b, long onOverflow) {
        try {
            return LongMath.checkedAdd((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            return onOverflow;
        }
    }

    @Override
    public CompletionStage<Void> write(CloudPath file, boolean replace, InputStream data, long size, Optional<Instant> lastModified, ProgressListener progressListener) {
        return this.getC9rPath(file).thenCompose(ciphertextPath -> {
            this.fileHeaderCache.evict((CloudPath)ciphertextPath);
            ReadableByteChannel src = Channels.newChannel(data);
            EncryptingReadableByteChannel encryptingChannel = new EncryptingReadableByteChannel(src, this.cryptor);
            InputStream encryptedIn = Channels.newInputStream((ReadableByteChannel)encryptingChannel);
            long numBytes = Cryptors.ciphertextSize((long)size, (Cryptor)this.cryptor) + (long)this.cryptor.fileHeaderCryptor().headerSize();
            return this.delegate.write((CloudPath)ciphertextPath, replace, encryptedIn, numBytes, lastModified, progressListener);
        });
    }

    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        byte[] dirId = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
        CloudPath dirPath = this.getDirPathWithId(dirId);
        CompletionStage<CloudPath> futureC9rFile = this.getC9rPath(folder).thenCompose(this.delegate::createFolder).thenCompose(folderPath -> this.delegate.write(folderPath.resolve(DIR_FILE_NAME), false, new ByteArrayInputStream(dirId), dirId.length, Optional.empty(), ProgressListener.NO_PROGRESS_AWARE));
        CompletionStage futureDir = this.delegate.createFolderIfNonExisting(dirPath.getParent()).thenCompose(unused -> this.delegate.createFolder(dirPath));
        return futureC9rFile.thenCombine(futureDir, (c9rFile, dir) -> folder);
    }

    @Override
    public CompletionStage<Void> deleteFile(CloudPath file) {
        return this.itemMetadata(file).thenCompose(cloudNode -> this.getC9rPath(file)).thenCompose(ciphertextPath -> {
            this.fileHeaderCache.evict((CloudPath)ciphertextPath);
            return this.delegate.deleteFile((CloudPath)ciphertextPath);
        });
    }

    @Override
    public CompletionStage<Void> deleteFolder(CloudPath folder) {
        return this.itemMetadata(folder).thenCompose(cloudNode -> this.deleteCiphertextDir(this.getDirPathFromClearTextDir(folder))).thenCompose(ignored -> this.getC9rPath(folder)).thenCompose(this.delegate::deleteFolder).thenRun(() -> this.dirIdCache.evictIncludingDescendants(folder));
    }

    private CompletionStage<Void> deleteCiphertextDir(CompletionStage<CloudPath> dirPath) {
        return dirPath.thenCompose(this.delegate::listExhaustively).thenApply(itemsList -> itemsList.getItems().stream().filter(subdir -> subdir.getItemType() == CloudItemType.FOLDER).map(CloudItemMetadata::getPath)).thenApply(subDirsC9rPath -> subDirsC9rPath.map(this::getDirPathFromC9rDir)).thenApply(subDirsDirPath -> subDirsDirPath.map(this::deleteCiphertextDir)).thenCompose(result -> {
            CompletableFuture[] futures = (CompletableFuture[])result.map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures);
        }).thenCombine(dirPath, (unused, path) -> path).thenCompose(this.delegate::deleteFolder);
    }

    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        return this.getC9rPath(source).thenCompose(sourceC9rPath -> {
            this.fileHeaderCache.evict((CloudPath)sourceC9rPath);
            return this.getC9rPath(target).thenCompose(targetC9rPath -> this.delegate.move((CloudPath)sourceC9rPath, (CloudPath)targetC9rPath, replace));
        }).thenApply(targetC9rPath -> {
            this.fileHeaderCache.evict((CloudPath)targetC9rPath);
            this.dirIdCache.evict(source);
            return target;
        });
    }

    private CloudItemList toCleartextItemList(CloudItemList ciphertextItemList, CloudPath cleartextParent, byte[] parentDirId) {
        List<CloudItemMetadata> items = ciphertextItemList.getItems().stream().flatMap(ciphertextMetadata -> {
            try {
                CloudItemMetadata cleartextMetadata = this.toCleartextMetadata((CloudItemMetadata)ciphertextMetadata, cleartextParent, parentDirId);
                return Stream.of(cleartextMetadata);
            }
            catch (AuthenticationFailedException e) {
                LOG.warn("Unauthentic ciphertext file name: {}", (Object)ciphertextMetadata.getPath());
                return Stream.empty();
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Skipping unknown file: {}", (Object)ciphertextMetadata.getPath());
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        return new CloudItemList(items, ciphertextItemList.getNextPageToken());
    }

    private CloudItemMetadata toCleartextMetadata(CloudItemMetadata ciphertextMetadata, CloudPath cleartextParent, byte[] parentDirId) throws AuthenticationFailedException, IllegalArgumentException {
        String ciphertextName = ciphertextMetadata.getName();
        Preconditions.checkArgument((boolean)ciphertextName.endsWith(CIPHERTEXT_FILE_SUFFIX), (Object)"Unrecognized file type");
        String ciphertextBaseName = ciphertextName.substring(0, ciphertextName.length() - CIPHERTEXT_FILE_SUFFIX.length());
        String cleartextName = this.cryptor.fileNameCryptor().decryptFilename(BaseEncoding.base64Url(), ciphertextBaseName, (byte[][])new byte[][]{parentDirId});
        return this.toCleartextMetadata(ciphertextMetadata, cleartextParent, cleartextName);
    }

    private CloudItemMetadata toCleartextMetadata(CloudItemMetadata ciphertextMetadata, CloudPath cleartextParent, String cleartextName) {
        CloudPath cleartextPath = cleartextParent.resolve(cleartextName);
        Optional<Long> cleartextSize = ciphertextMetadata.getSize().map(n -> {
            switch (ciphertextMetadata.getItemType()) {
                case FILE: {
                    return Cryptors.cleartextSize((long)(n - (long)this.cryptor.fileHeaderCryptor().headerSize()), (Cryptor)this.cryptor);
                }
                case FOLDER: {
                    return 0L;
                }
            }
            throw new IllegalStateException("Unable to retrieve cleartextSize cause of unkown type");
        });
        return new CloudItemMetadata(cleartextName, cleartextPath, ciphertextMetadata.getItemType(), ciphertextMetadata.getLastModifiedDate(), cleartextSize);
    }

    private CompletionStage<byte[]> getDirId(CloudPath cleartextDir) {
        Preconditions.checkNotNull((Object)cleartextDir);
        return this.dirIdCache.get(cleartextDir, (cleartextPath, parentDirId) -> {
            String cleartextName = cleartextPath.getFileName().toString();
            CloudPath ciphertextPath = this.getC9rPath((byte[])parentDirId, cleartextName);
            CloudPath dirFileUrl = ciphertextPath.resolve(DIR_FILE_NAME);
            return this.delegate.read(dirFileUrl, ProgressListener.NO_PROGRESS_AWARE).thenCompose(this::readAllBytes);
        });
    }

    private CompletionStage<FileHeader> readFileHeader(CloudPath ciphertextPath) {
        FileHeaderCryptor headerCryptor = this.cryptor.fileHeaderCryptor();
        return this.delegate.read(ciphertextPath, 0L, headerCryptor.headerSize(), ProgressListener.NO_PROGRESS_AWARE).thenCompose(this::readAllBytes).thenApply(bytes -> headerCryptor.decryptHeader(ByteBuffer.wrap(bytes)));
    }

    private CompletionStage<byte[]> readAllBytes(InputStream inputStream) {
        CompletableFuture<byte[]> completableFuture;
        block8: {
            InputStream in = inputStream;
            try {
                completableFuture = CompletableFuture.completedFuture(in.readAllBytes());
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }
            in.close();
        }
        return completableFuture;
    }

    private CompletionStage<CloudPath> getDirPathFromClearTextDir(CloudPath cleartextDir) {
        return this.getDirId(cleartextDir).thenApply(this::getDirPathWithId);
    }

    private CompletionStage<CloudPath> getDirPathFromC9rDir(CloudPath dirC9rPath) {
        return this.delegate.read(dirC9rPath.resolve(DIR_FILE_NAME), ProgressListener.NO_PROGRESS_AWARE).thenCompose(this::readAllBytes).thenApply(this::getDirPathWithId);
    }

    private CloudPath getDirPathWithId(byte[] dirId) {
        String digest = this.cryptor.fileNameCryptor().hashDirectoryId(new String(dirId, StandardCharsets.UTF_8));
        return this.dataDir.resolve(digest.substring(0, 2)).resolve(digest.substring(2));
    }

    private CloudPath getC9rPath(byte[] parentDirId, String cleartextName) {
        String ciphertextBaseName = this.cryptor.fileNameCryptor().encryptFilename(BaseEncoding.base64Url(), cleartextName, (byte[][])new byte[][]{parentDirId});
        String ciphertextName = ciphertextBaseName + CIPHERTEXT_FILE_SUFFIX;
        return this.getDirPathWithId(parentDirId).resolve(ciphertextName);
    }

    private CompletionStage<CloudPath> getC9rPath(CloudPath cleartextPath) {
        Preconditions.checkArgument((cleartextPath.getNameCount() > 0 ? 1 : 0) != 0, (Object)"No c9r path for root.");
        CloudPath cleartextParent = cleartextPath.getNameCount() == 1 ? CloudPath.of("", new String[0]) : cleartextPath.getParent();
        String cleartextName = cleartextPath.getFileName().toString();
        return this.getDirId(cleartextParent).thenApply(parentDirId -> this.getC9rPath((byte[])parentDirId, cleartextName));
    }
}

