/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.api;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;

public class CloudItemList {
    private final List<CloudItemMetadata> items;
    private final Optional<String> nextPageToken;

    public CloudItemList(List<CloudItemMetadata> items, Optional<String> nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public CloudItemList(List<CloudItemMetadata> items) {
        this(items, Optional.empty());
    }

    public List<CloudItemMetadata> getItems() {
        return this.items;
    }

    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public CloudItemList add(List<CloudItemMetadata> items, Optional<String> nextPageToken) {
        List<CloudItemMetadata> union = Stream.concat(this.items.stream(), items.stream()).collect(Collectors.toList());
        return new CloudItemList(union, nextPageToken);
    }

    public CloudItemList add(List<CloudItemMetadata> items) {
        return this.add(items, Optional.empty());
    }

    public static CloudItemList empty() {
        return new CloudItemList(Collections.emptyList());
    }
}

