/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CompletionStage;
import org.cryptomator.cloudaccess.MetadataCachingProviderDecorator;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.api.exceptions.VaultKeyVerificationFailedException;
import org.cryptomator.cloudaccess.api.exceptions.VaultVerificationFailedException;
import org.cryptomator.cloudaccess.api.exceptions.VaultVersionVerificationFailedException;
import org.cryptomator.cloudaccess.localfs.LocalFsCloudProvider;
import org.cryptomator.cloudaccess.vaultformat8.VaultFormat8ProviderDecorator;
import org.cryptomator.cloudaccess.webdav.WebDavCloudProvider;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;

public class CloudAccess {
    private CloudAccess() {
    }

    public static CloudProvider vaultFormat8GCMCloudAccess(CloudProvider cloudProvider, CloudPath pathToVault, byte[] rawKey) {
        Preconditions.checkArgument((rawKey.length == 64 ? 1 : 0) != 0, (Object)"masterkey needs to be 512 bit");
        try {
            SecureRandom csprng = SecureRandom.getInstanceStrong();
            Cryptor cryptor = Cryptors.version2((SecureRandom)csprng).createFromRawKey(rawKey);
            CloudAccess.verifyVaultFormat8GCMConfig(cloudProvider, pathToVault, rawKey);
            VaultFormat8ProviderDecorator provider = new VaultFormat8ProviderDecorator(cloudProvider, pathToVault.resolve("d"), cryptor);
            provider.initialize();
            return new MetadataCachingProviderDecorator(provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JVM doesn't supply a CSPRNG", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CloudProviderException("Vault initialization interrupted.", e);
        }
    }

    private static void verifyVaultFormat8GCMConfig(CloudProvider cloudProvider, CloudPath pathToVault, byte[] rawKey) {
        CloudPath vaultConfigPath = pathToVault.resolve("vaultconfig.jwt");
        Algorithm algorithm = Algorithm.HMAC256((byte[])rawKey);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("version", Integer.valueOf(8)).withClaim("ciphermode", "SIV_GCM").build();
        CompletionStage<InputStream> read = cloudProvider.read(vaultConfigPath, ProgressListener.NO_PROGRESS_AWARE);
        try (InputStream in = read.toCompletableFuture().join();){
            byte[] vaultConfigContents = in.readAllBytes();
            String token = new String(vaultConfigContents, StandardCharsets.US_ASCII);
            verifier.verify(token);
        }
        catch (SignatureVerificationException e) {
            throw new VaultKeyVerificationFailedException((JWTVerificationException)((Object)e));
        }
        catch (JWTVerificationException e) {
            if (e.getMessage().equals("The Claim 'version' value doesn't match the required one.")) {
                throw new VaultVersionVerificationFailedException(e);
            }
            throw new VaultVerificationFailedException(e);
        }
        catch (IOException | CloudProviderException e) {
            throw new CloudProviderException(e);
        }
    }

    public static CloudProvider toWebDAV(URL url, String username, CharSequence password) {
        return WebDavCloudProvider.from(WebDavCredential.from(url, username, password.toString()));
    }

    public static CloudProvider toLocalFileSystem(Path folder) {
        return new LocalFsCloudProvider(folder);
    }
}

