/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final long size;

    private InputStreamRequestBody(InputStream inputStream, long size) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"Inputstream must be provided");
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Size must be positive");
        this.inputStream = inputStream;
        this.size = size;
    }

    public static RequestBody from(InputStream inputStream, long size) {
        return new InputStreamRequestBody(inputStream, size);
    }

    public MediaType contentType() {
        return MediaType.parse((String)"application/octet-stream");
    }

    public long contentLength() {
        return this.size;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = Okio.source((InputStream)this.inputStream);){
            sink.writeAll(source);
        }
    }
}

