/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.vaultformat8;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.cryptomator.cloudaccess.api.CloudPath;

class DirectoryIdCache {
    private static final byte[] ROOT_DIR_ID = new byte[0];
    private static final Map<CloudPath, byte[]> ROOT_MAPPINGS = Map.of(CloudPath.of("", new String[0]), ROOT_DIR_ID, CloudPath.of("/", new String[0]), ROOT_DIR_ID);
    private final ConcurrentMap<CloudPath, byte[]> cache = new ConcurrentHashMap<CloudPath, byte[]>(ROOT_MAPPINGS);

    DirectoryIdCache() {
    }

    public CompletionStage<byte[]> get(CloudPath cleartextPath, BiFunction<CloudPath, byte[], CompletionStage<byte[]>> onMiss) {
        byte[] cached = (byte[])this.cache.get(cleartextPath);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        CloudPath parentPath = cleartextPath.getNameCount() == 1 ? CloudPath.of("", new String[0]) : cleartextPath.getParent();
        return this.get(parentPath, onMiss).thenCompose(parentDirId -> (CompletionStage)onMiss.apply(cleartextPath, (byte[])parentDirId)).thenApply(dirId -> {
            this.cache.put(cleartextPath, (byte[])dirId);
            return dirId;
        });
    }

    public void evict(CloudPath cleartextPath) {
        this.cache.remove(cleartextPath);
    }

    public void evictIncludingDescendants(CloudPath cleartextPath) {
        for (CloudPath path : this.cache.keySet()) {
            if (!path.startsWith(cleartextPath)) continue;
            this.cache.remove(path);
        }
    }

    Optional<byte[]> getCached(CloudPath cleartextPath) {
        return Optional.ofNullable((byte[])this.cache.get(cleartextPath));
    }
}

