/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.Quota;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;

public class MetadataCachingProviderDecorator
implements CloudProvider {
    private static final int DEFAULT_CACHE_TIMEOUT_SECONDS = 10;
    final Cache<CloudPath, Optional<CloudItemMetadata>> itemMetadataCache;
    final Cache<CloudPath, Optional<Quota>> quotaCache;
    private final CloudProvider delegate;

    public MetadataCachingProviderDecorator(CloudProvider delegate) {
        this(delegate, Duration.ofSeconds(Integer.getInteger("org.cryptomator.cloudaccess.metadatacachingprovider.timeoutSeconds", 10).intValue()));
    }

    public MetadataCachingProviderDecorator(CloudProvider delegate, Duration cacheEntryMaxAge) {
        this.delegate = delegate;
        this.itemMetadataCache = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryMaxAge).build();
        this.quotaCache = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryMaxAge).build();
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        Optional cachedMetadata = (Optional)this.itemMetadataCache.getIfPresent((Object)node);
        if (cachedMetadata != null) {
            return cachedMetadata.map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.failedFuture(new NotFoundException()));
        }
        return this.delegate.itemMetadata(node).whenComplete((metadata, exception) -> {
            if (exception == null) {
                assert (metadata != null);
                this.itemMetadataCache.put((Object)node, Optional.of(metadata));
            } else if (exception instanceof NotFoundException) {
                this.itemMetadataCache.put((Object)node, Optional.empty());
            } else {
                this.itemMetadataCache.invalidate((Object)node);
            }
        });
    }

    @Override
    public CompletionStage<Quota> quota(CloudPath folder) {
        Optional cachedMetadata = (Optional)this.quotaCache.getIfPresent((Object)folder);
        if (cachedMetadata != null) {
            return cachedMetadata.map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.failedFuture(new NotFoundException()));
        }
        return this.delegate.quota(folder).whenComplete((quota, exception) -> {
            if (exception == null) {
                assert (quota != null);
                this.quotaCache.put((Object)folder, Optional.of(quota));
            } else if (exception instanceof NotFoundException) {
                this.quotaCache.put((Object)folder, Optional.empty());
            } else {
                this.quotaCache.invalidate((Object)folder);
            }
        });
    }

    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        return this.delegate.list(folder, pageToken).whenComplete((cloudItemList, exception) -> {
            this.evictIncludingDescendants(folder);
            if (exception == null) {
                assert (cloudItemList != null);
                cloudItemList.getItems().forEach(metadata -> this.itemMetadataCache.put((Object)metadata.getPath(), Optional.of(metadata)));
            }
        });
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, ProgressListener progressListener) {
        return this.delegate.read(file, progressListener).whenComplete((metadata, exception) -> {
            if (exception != null) {
                this.itemMetadataCache.invalidate((Object)file);
            }
        });
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        return this.delegate.read(file, offset, count, progressListener).whenComplete((inputStream, exception) -> {
            if (exception != null) {
                this.itemMetadataCache.invalidate((Object)file);
            }
        });
    }

    @Override
    public CompletionStage<Void> write(CloudPath file, boolean replace, InputStream data, long size, Optional<Instant> lastModified, ProgressListener progressListener) {
        return this.delegate.write(file, replace, data, size, lastModified, progressListener).whenComplete((nullReturn, exception) -> {
            if (exception != null) {
                this.itemMetadataCache.invalidate((Object)file);
                this.quotaCache.invalidateAll();
            }
        });
    }

    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        return this.delegate.createFolder(folder).whenComplete((metadata, exception) -> this.itemMetadataCache.invalidate((Object)folder));
    }

    @Override
    public CompletionStage<Void> delete(CloudPath node) {
        return this.delegate.delete(node).whenComplete((nullReturn, exception) -> {
            this.evictIncludingDescendants(node);
            this.quotaCache.invalidateAll();
        });
    }

    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        return this.delegate.move(source, target, replace).whenComplete((path, exception) -> {
            this.itemMetadataCache.invalidate((Object)source);
            this.itemMetadataCache.invalidate((Object)target);
            this.quotaCache.invalidateAll();
        });
    }

    private void evictIncludingDescendants(CloudPath cleartextPath) {
        for (CloudPath path : this.itemMetadataCache.asMap().keySet()) {
            if (!path.startsWith(cleartextPath)) continue;
            this.itemMetadataCache.invalidate((Object)path);
        }
    }
}

