/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import com.google.common.base.Splitter;
import com.google.common.collect.Streams;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class PropfindEntryData {
    private static final Pattern URI_PATTERN = Pattern.compile("^[a-z]+://[^/]+/(.*)$");
    private String path;
    private boolean collection = true;
    private Optional<Instant> lastModified = Optional.empty();
    private Optional<Long> size = Optional.empty();

    PropfindEntryData() {
    }

    private String extractPath(String pathOrUri) {
        Matcher matcher = URI_PATTERN.matcher(pathOrUri);
        if (matcher.matches()) {
            return this.urlDecode(matcher.group(1));
        }
        if (!pathOrUri.startsWith("/")) {
            return this.urlDecode("/" + pathOrUri);
        }
        return this.urlDecode(pathOrUri);
    }

    private String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public Optional<Instant> getLastModified() {
        return this.lastModified;
    }

    void setLastModified(Optional<Instant> lastModified) {
        this.lastModified = lastModified;
    }

    public String getPath() {
        return this.path;
    }

    void setPath(String pathOrUri) {
        this.path = this.extractPath(pathOrUri);
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    void setSize(Optional<Long> size) {
        this.size = size;
    }

    public boolean isCollection() {
        return this.collection;
    }

    void setCollection(boolean collection) {
        this.collection = collection;
    }

    public long getDepth() {
        return Splitter.on((String)"/").omitEmptyStrings().splitToStream((CharSequence)this.path).count();
    }

    public String getName() {
        return Streams.findLast((Stream)Splitter.on((String)"/").omitEmptyStrings().splitToStream((CharSequence)this.path)).orElse("");
    }
}

