/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.localfs;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.AlreadyExistsException;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;
import org.cryptomator.cloudaccess.api.exceptions.TypeMismatchException;

public class LocalFsCloudProvider
implements CloudProvider {
    private static final CloudPath ABS_ROOT = CloudPath.of("/", new String[0]);
    private final Path root;
    private final ReadWriteLock lock;

    public LocalFsCloudProvider(Path root) {
        this.root = root;
        this.lock = new ReentrantReadWriteLock();
    }

    private Path resolve(CloudPath cloudPath) {
        String relPath = ABS_ROOT.relativize(cloudPath).toString();
        return this.root.resolve(relPath);
    }

    private CloudItemMetadata createMetadata(Path fullPath, BasicFileAttributes attr) {
        Path relPath = this.root.relativize(fullPath);
        CloudItemType type = attr.isDirectory() ? CloudItemType.FOLDER : (attr.isRegularFile() ? CloudItemType.FILE : CloudItemType.UNKNOWN);
        Optional<Instant> modifiedDate = Optional.of(attr.lastModifiedTime().toInstant());
        Optional<Long> size = Optional.of(attr.size());
        return new CloudItemMetadata(relPath.getFileName().toString(), ABS_ROOT.resolve(relPath.toString()), type, modifiedDate, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        Path path = this.resolve(node);
        Lock l = this.lock.readLock();
        l.lock();
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            CloudItemMetadata metadata = this.createMetadata(path, attr);
            CompletableFuture<CloudItemMetadata> completableFuture = CompletableFuture.completedFuture(metadata);
            return completableFuture;
        }
        catch (NoSuchFileException e) {
            CompletableFuture<CloudItemMetadata> completableFuture = CompletableFuture.failedFuture(new NotFoundException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<CloudItemMetadata> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        Path folderPath = this.resolve(folder);
        Lock l = this.lock.readLock();
        l.lock();
        try {
            final ArrayList<CloudItemMetadata> items = new ArrayList<CloudItemMetadata>();
            LocalFsCloudProvider provider = this;
            Files.walkFileTree(folderPath, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    items.add(LocalFsCloudProvider.this.createMetadata(file, attrs));
                    return FileVisitResult.CONTINUE;
                }
            });
            CompletableFuture<CloudItemList> completableFuture = CompletableFuture.completedFuture(new CloudItemList(items, Optional.empty()));
            return completableFuture;
        }
        catch (NoSuchFileException e) {
            CompletableFuture<CloudItemList> completableFuture = CompletableFuture.failedFuture(new NotFoundException(e));
            return completableFuture;
        }
        catch (NotDirectoryException e) {
            CompletableFuture<CloudItemList> completableFuture = CompletableFuture.failedFuture(new TypeMismatchException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<CloudItemList> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        Path filePath = this.resolve(file);
        Lock l = this.lock.readLock();
        l.lock();
        try {
            SeekableByteChannel ch = Files.newByteChannel(filePath, StandardOpenOption.READ);
            ch.position(offset);
            CompletableFuture<InputStream> completableFuture = CompletableFuture.completedFuture(ByteStreams.limit((InputStream)Channels.newInputStream(ch), (long)count));
            return completableFuture;
        }
        catch (NoSuchFileException e) {
            CompletableFuture<InputStream> completableFuture = CompletableFuture.failedFuture(new NotFoundException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<InputStream> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<CloudItemMetadata> write(CloudPath file, boolean replace, InputStream data, long size, ProgressListener progressListener) {
        Path filePath = this.resolve(file);
        EnumSet<StandardOpenOption> options = replace ? EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING) : EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            CompletableFuture<CloudItemMetadata> completableFuture;
            block15: {
                FileChannel ch = FileChannel.open(filePath, options, new FileAttribute[0]);
                try {
                    long tmpSize = ch.transferFrom(Channels.newChannel(data), 0L, Long.MAX_VALUE);
                    Instant modifiedDate = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
                    CloudItemMetadata metadata = new CloudItemMetadata(file.getFileName().toString(), file, CloudItemType.FILE, Optional.of(modifiedDate), Optional.of(tmpSize));
                    completableFuture = CompletableFuture.completedFuture(metadata);
                    if (ch == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ch != null) {
                            try {
                                ch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException e) {
                        CompletableFuture<CloudItemMetadata> completableFuture2 = CompletableFuture.failedFuture(new NotFoundException(e));
                        return completableFuture2;
                    }
                    catch (FileAlreadyExistsException e) {
                        CompletableFuture<CloudItemMetadata> completableFuture3 = CompletableFuture.failedFuture(new AlreadyExistsException(e));
                        return completableFuture3;
                    }
                    catch (IOException e) {
                        CompletableFuture<CloudItemMetadata> completableFuture4 = CompletableFuture.failedFuture(new CloudProviderException(e));
                        return completableFuture4;
                    }
                }
                ch.close();
            }
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        Path folderPath = this.resolve(folder);
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            Files.createDirectory(folderPath, new FileAttribute[0]);
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.completedFuture(folder);
            return completableFuture;
        }
        catch (FileAlreadyExistsException e) {
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.failedFuture(new AlreadyExistsException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> delete(CloudPath node) {
        Path path = this.resolve(node);
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        catch (NoSuchFileException e) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new NotFoundException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        Path src = this.resolve(source);
        Path dst = this.resolve(target);
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            EnumSet<StandardCopyOption> options = replace ? EnumSet.of(StandardCopyOption.REPLACE_EXISTING) : EnumSet.noneOf(StandardCopyOption.class);
            Files.move(src, dst, (CopyOption[])options.toArray(CopyOption[]::new));
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.completedFuture(target);
            return completableFuture;
        }
        catch (NoSuchFileException e) {
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.failedFuture(new NotFoundException(e));
            return completableFuture;
        }
        catch (FileAlreadyExistsException e) {
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.failedFuture(new AlreadyExistsException(e));
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<CloudPath> completableFuture = CompletableFuture.failedFuture(new CloudProviderException(e));
            return completableFuture;
        }
        finally {
            l.unlock();
        }
    }
}

