/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess;

import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.cryptomator.cloudaccess.MetadataCachingProviderDecorator;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.localfs.LocalFsCloudProvider;
import org.cryptomator.cloudaccess.vaultformat8.VaultFormat8ProviderDecorator;
import org.cryptomator.cloudaccess.webdav.WebDavCloudProvider;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;

public class CloudAccess {
    private CloudAccess() {
    }

    public static CloudProvider vaultFormat8GCMCloudAccess(CloudProvider cloudProvider, CloudPath pathToVault, byte[] rawKey) {
        try {
            SecureRandom csprng = SecureRandom.getInstanceStrong();
            Cryptor cryptor = Cryptors.version2((SecureRandom)csprng).createFromRawKey(rawKey);
            VaultFormat8ProviderDecorator provider = new VaultFormat8ProviderDecorator(cloudProvider, pathToVault.resolve("d"), cryptor);
            provider.initialize();
            return new MetadataCachingProviderDecorator(provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JVM doesn't supply a CSPRNG", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CloudProviderException("Vault initialization interrupted.", e);
        }
    }

    public static CloudProvider toWebDAV(URL url, String username, CharSequence password) {
        WebDavCloudProvider webdavCloudProvider = WebDavCloudProvider.from(WebDavCredential.from(url, username, password.toString()));
        return new MetadataCachingProviderDecorator(webdavCloudProvider);
    }

    public static CloudProvider toLocalFileSystem(Path folder) {
        return new LocalFsCloudProvider(folder);
    }
}

