/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class WebDavRedirectHandler {
    private static final int MAX_REDIRECT_COUNT = 20;
    private static final Request NO_REDIRECTED_REQUEST = null;
    private static final HttpUrl NO_REDIRECT_URL = null;
    private final OkHttpClient httpClient;

    WebDavRedirectHandler(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Response executeFollowingRedirects(Request request) throws IOException {
        Response response;
        int redirectCount = 0;
        do {
            if (redirectCount > 20) {
                throw new ProtocolException("Too many redirects: " + redirectCount);
            }
            response = this.httpClient.newCall(request).execute();
            request = this.redirectedRequestFor(response);
            ++redirectCount;
        } while (request != NO_REDIRECTED_REQUEST);
        return response;
    }

    private Request redirectedRequestFor(Response response) {
        switch (response.code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.createRedirectedRequest(response);
            }
        }
        return NO_REDIRECTED_REQUEST;
    }

    private Request createRedirectedRequest(Response response) {
        HttpUrl url = this.redirectUrl(response);
        if (url == NO_REDIRECT_URL) {
            return NO_REDIRECTED_REQUEST;
        }
        return this.createRedirectedRequest(response, url);
    }

    private Request createRedirectedRequest(Response response, HttpUrl url) {
        Request.Builder requestBuilder = response.request().newBuilder().url(url);
        if (this.methodShouldBeChangedToGet(response)) {
            this.changeMethodToGet(requestBuilder);
        }
        if (!this.connectionMatches(response.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.build();
    }

    private boolean methodShouldBeChangedToGet(Response response) {
        return response.code() == 300 || response.code() == 303;
    }

    private void changeMethodToGet(Request.Builder requestBuilder) {
        requestBuilder.method("GET", null).removeHeader("Transfer-Encoding").removeHeader("Content-Length").removeHeader("Content-Type");
    }

    private boolean connectionMatches(HttpUrl url1, HttpUrl url2) {
        return url1.scheme().equals(url2.scheme()) && url1.host().equals(url2.host()) && url1.port() == url2.port();
    }

    private HttpUrl redirectUrl(Response response) {
        String location = response.header("Location");
        if (location == null) {
            return NO_REDIRECT_URL;
        }
        return response.request().url().resolve(location);
    }
}

