/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.cryptomator.cloudaccess.api.ProgressListener;

class ProgressResponseWrapper
extends ResponseBody {
    private final ResponseBody delegate;
    private final ProgressListener progressListener;
    private final int EOF = -1;
    private BufferedSource bufferedSource;

    ProgressResponseWrapper(ResponseBody delegate, ProgressListener progressListener) {
        this.delegate = delegate;
        this.progressListener = progressListener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        return this.delegate.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.delegate.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (bytesRead != -1L) {
                    ProgressResponseWrapper.this.progressListener.onProgress(this.totalBytesRead);
                }
                return bytesRead;
            }
        };
    }
}

