/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.cryptomator.cloudaccess.api.ProgressListener;

public class ProgressRequestWrapper
extends RequestBody {
    protected RequestBody delegate;
    protected ProgressListener listener;

    public ProgressRequestWrapper(RequestBody delegate, ProgressListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            ProgressRequestWrapper.this.listener.onProgress(this.bytesWritten);
        }
    }
}

