/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.cryptomator.cloudaccess.webdav.HeaderNames;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final HeaderNames EXCLUDED_HEADERS = new HeaderNames("Content-Type", "Content-Length", "Authorization", "WWW-Authenticate", "Cookie", "Set-Cookie");
    private final Logger logger;

    public HttpLoggingInterceptor(Logger logger) {
        this.logger = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.proceedWithLogging(chain);
    }

    private Response proceedWithLogging(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.logRequest(request, chain);
        return this.getAndLogResponse(request, chain);
    }

    private void logRequest(Request request, Interceptor.Chain chain) throws IOException {
        this.logRequestStart(request, chain);
        this.logContentTypeAndLength(request);
        this.logHeaders(request.headers());
        this.logRequestEnd(request);
    }

    private Response getAndLogResponse(Request request, Interceptor.Chain chain) throws IOException {
        long startOfRequestMs = System.nanoTime();
        Response response = this.getResponseLoggingExceptions(request, chain);
        long requestDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startOfRequestMs);
        this.logResponse(response, requestDurationMs);
        return response;
    }

    private Response getResponseLoggingExceptions(Request request, Interceptor.Chain chain) throws IOException {
        try {
            return chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log("<-- HTTP FAILED: " + e);
            throw e;
        }
    }

    private void logResponse(Response response, long requestDurationMs) {
        this.logResponseStart(response, requestDurationMs);
        this.logHeaders(response.headers());
        this.logger.log("<-- END HTTP");
    }

    private void logRequestStart(Request request, Interceptor.Chain chain) throws IOException {
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        String bodyLength = this.hasBody(request) ? request.body().contentLength() + "-byte body" : "unknown length";
        this.logger.log(String.format("--> %s %s %s (%s)", request.method(), request.url(), protocol, bodyLength));
    }

    private void logContentTypeAndLength(Request request) throws IOException {
        if (this.hasBody(request)) {
            RequestBody body = request.body();
            if (body.contentType() != null) {
                this.logger.log("Content-Type: " + body.contentType());
            }
            if (body.contentLength() != -1L) {
                this.logger.log("Content-Length: " + body.contentLength());
            }
        }
    }

    private void logRequestEnd(Request request) throws IOException {
        this.logger.log("--> END " + request.method());
    }

    private void logResponseStart(Response response, long requestDurationMs) {
        this.logger.log("<-- " + response.code() + " " + response.message() + " " + response.request().url() + " (" + requestDurationMs + "ms)");
    }

    private boolean hasBody(Request request) {
        return request.body() != null;
    }

    private void logHeaders(Headers headers) {
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            String name = headers.name(i);
            if (this.isExcludedHeader(name)) continue;
            this.logger.log(name + ": " + headers.value(i));
        }
    }

    private boolean isExcludedHeader(String name) {
        return EXCLUDED_HEADERS.contains(name);
    }

    public static interface Logger {
        public void log(String var1);
    }
}

