/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.vaultformat8;

import com.google.common.base.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OffsetInputStream
extends FilterInputStream {
    private long toBeSkipped;

    protected OffsetInputStream(InputStream in, long offset) {
        super(in);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be non-negative");
        this.toBeSkipped = offset;
    }

    private void skipToOffset() throws IOException {
        byte[] buf = new byte[1024];
        while (this.toBeSkipped > 0L) {
            int read = this.in.read(buf, 0, (int)Math.min((long)buf.length, this.toBeSkipped));
            if (read == -1) {
                this.toBeSkipped = 0L;
                continue;
            }
            this.toBeSkipped -= (long)read;
        }
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(0L, (long)this.in.available() - this.toBeSkipped);
    }

    @Override
    public long skip(long n) throws IOException {
        this.skipToOffset();
        return super.skip(n);
    }

    @Override
    public int read() throws IOException {
        this.skipToOffset();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.skipToOffset();
        return super.read(b, off, len);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

