/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.api;

import com.google.common.base.Objects;
import java.time.Instant;
import java.util.Optional;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;

public class CloudItemMetadata {
    private final String name;
    private final CloudPath path;
    private final CloudItemType itemType;
    private final Optional<Instant> lastModifiedDate;
    private final Optional<Long> size;

    public CloudItemMetadata(String name, CloudPath path, CloudItemType itemType, Optional<Instant> lastModifiedDate, Optional<Long> size) {
        this.name = name;
        this.path = path;
        this.itemType = itemType;
        this.lastModifiedDate = lastModifiedDate;
        this.size = size;
    }

    public CloudItemMetadata(String name, CloudPath path, CloudItemType itemType) {
        this(name, path, itemType, Optional.empty(), Optional.empty());
    }

    public String getName() {
        return this.name;
    }

    public CloudPath getPath() {
        return this.path;
    }

    public CloudItemType getItemType() {
        return this.itemType;
    }

    public Optional<Instant> getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudItemMetadata that = (CloudItemMetadata)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.path, (Object)that.path) && this.itemType == that.itemType && Objects.equal(this.lastModifiedDate, that.lastModifiedDate) && Objects.equal(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.path, this.itemType, this.lastModifiedDate, this.size});
    }

    public String toString() {
        return "CloudItemMetadata{itemType=" + this.itemType + ", path=" + this.path + ", name=" + this.name + "}";
    }
}

