/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;

public class MetadataCachingProviderDecorator
implements CloudProvider {
    private final CloudProvider delegate;
    final Cache<CloudPath, Optional<CloudItemMetadata>> metadataCache;

    public MetadataCachingProviderDecorator(CloudProvider delegate) {
        this(delegate, Duration.ofSeconds(10L));
    }

    public MetadataCachingProviderDecorator(CloudProvider delegate, Duration cacheEntryMaxAge) {
        this.delegate = delegate;
        this.metadataCache = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryMaxAge).build();
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        Optional cachedMetadata = (Optional)this.metadataCache.getIfPresent((Object)node);
        if (cachedMetadata != null) {
            return cachedMetadata.map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.failedFuture(new NotFoundException()));
        }
        return this.delegate.itemMetadata(node).handle((metadata, exception) -> {
            if (exception == null) {
                assert (metadata != null);
                this.metadataCache.put((Object)node, Optional.of(metadata));
                return CompletableFuture.completedFuture(metadata);
            }
            if (exception instanceof NotFoundException) {
                this.metadataCache.put((Object)node, Optional.empty());
                return CompletableFuture.failedFuture(exception);
            }
            this.metadataCache.invalidate((Object)node);
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        return this.delegate.list(folder, pageToken).handle((cloudItemList, exception) -> {
            this.evictIncludingDescendants(folder);
            if (exception == null) {
                assert (cloudItemList != null);
                cloudItemList.getItems().forEach(metadata -> this.metadataCache.put((Object)metadata.getPath(), Optional.of(metadata)));
                return CompletableFuture.completedFuture(cloudItemList);
            }
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, ProgressListener progressListener) {
        return this.delegate.read(file, progressListener).handle((metadata, exception) -> {
            if (exception == null) {
                assert (metadata != null);
                return CompletableFuture.completedFuture(metadata);
            }
            this.metadataCache.invalidate((Object)file);
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        return this.delegate.read(file, offset, count, progressListener).handle((inputStream, exception) -> {
            if (exception == null) {
                assert (inputStream != null);
                return CompletableFuture.completedFuture(inputStream);
            }
            this.metadataCache.invalidate((Object)file);
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<CloudItemMetadata> write(CloudPath file, boolean replace, InputStream data, long size, ProgressListener progressListener) {
        return this.delegate.write(file, replace, data, size, progressListener).thenApply(metadata -> {
            this.metadataCache.put((Object)file, Optional.of(metadata));
            return metadata;
        }).handle((metadata, exception) -> {
            if (exception == null) {
                assert (metadata != null);
                return CompletableFuture.completedFuture(metadata);
            }
            this.metadataCache.invalidate((Object)file);
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        return this.delegate.createFolder(folder).handle((metadata, exception) -> {
            this.metadataCache.invalidate((Object)folder);
            if (exception == null) {
                assert (metadata != null);
                return CompletableFuture.completedFuture(metadata);
            }
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<Void> delete(CloudPath node) {
        return this.delegate.delete(node).handle((nullReturn, exception) -> {
            this.evictIncludingDescendants(node);
            if (exception == null) {
                return CompletableFuture.completedFuture(nullReturn);
            }
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        return this.delegate.move(source, target, replace).handle((path, exception) -> {
            this.metadataCache.invalidate((Object)source);
            this.metadataCache.invalidate((Object)target);
            if (exception == null) {
                return CompletableFuture.completedFuture(path);
            }
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    private void evictIncludingDescendants(CloudPath cleartextPath) {
        for (CloudPath path : this.metadataCache.asMap().keySet()) {
            if (!path.startsWith(cleartextPath)) continue;
            this.metadataCache.invalidate((Object)path);
        }
    }
}

