/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.DispatchingAuthenticator;
import com.burgstaller.okhttp.basic.BasicAuthenticator;
import com.burgstaller.okhttp.digest.CachingAuthenticator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.cryptomator.cloudaccess.api.NetworkTimeout;
import org.cryptomator.cloudaccess.webdav.HttpLoggingInterceptor;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;
import org.cryptomator.cloudaccess.webdav.WebDavRedirectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebDavCompatibleHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebDavCompatibleHttpClient.class);
    private final WebDavRedirectHandler webDavRedirectHandler;

    WebDavCompatibleHttpClient(WebDavCredential webDavCredential) {
        this.webDavRedirectHandler = new WebDavRedirectHandler(WebDavCompatibleHttpClient.httpClientFor(webDavCredential));
    }

    private static OkHttpClient httpClientFor(WebDavCredential webDavCredential) {
        ConcurrentHashMap<String, CachingAuthenticator> authCache = new ConcurrentHashMap<String, CachingAuthenticator>();
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectTimeout(NetworkTimeout.CONNECTION.getTimeout(), NetworkTimeout.CONNECTION.getUnit()).readTimeout(NetworkTimeout.READ.getTimeout(), NetworkTimeout.READ.getUnit()).writeTimeout(NetworkTimeout.WRITE.getTimeout(), NetworkTimeout.WRITE.getUnit()).followRedirects(false).addInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)LOG).info(arg_0))).authenticator(WebDavCompatibleHttpClient.httpAuthenticator(webDavCredential.getUsername(), webDavCredential.getPassword(), authCache)).addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache));
        return builder.build();
    }

    private static Authenticator httpAuthenticator(String username, String password, Map<String, CachingAuthenticator> authCache) {
        Credentials credentials = new Credentials(username, password);
        DigestAuthenticator digestAuthenticator = new DigestAuthenticator(credentials);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(credentials, StandardCharsets.UTF_8);
        DispatchingAuthenticator dispatchingAuthenticator = new DispatchingAuthenticator.Builder().with("digest", (Authenticator)digestAuthenticator).with("basic", (Authenticator)basicAuthenticator).build();
        return new CachingAuthenticatorDecorator((Authenticator)dispatchingAuthenticator, authCache);
    }

    Response execute(Request.Builder requestBuilder) throws IOException {
        return this.execute(requestBuilder.build());
    }

    private Response execute(Request request) throws IOException {
        return this.webDavRedirectHandler.executeFollowingRedirects(request);
    }
}

