/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.AlreadyExistsException;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.api.exceptions.InsufficientStorageException;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;
import org.cryptomator.cloudaccess.webdav.ForbiddenException;
import org.cryptomator.cloudaccess.webdav.InputStreamRequestBody;
import org.cryptomator.cloudaccess.webdav.ProgressRequestWrapper;
import org.cryptomator.cloudaccess.webdav.ProgressResponseWrapper;
import org.cryptomator.cloudaccess.webdav.PropfindEntryData;
import org.cryptomator.cloudaccess.webdav.PropfindResponseParser;
import org.cryptomator.cloudaccess.webdav.ServerNotWebdavCompatibleException;
import org.cryptomator.cloudaccess.webdav.UnauthorizedException;
import org.cryptomator.cloudaccess.webdav.WebDavCompatibleHttpClient;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;
import org.xml.sax.SAXException;

public class WebDavClient {
    private final WebDavCompatibleHttpClient httpClient;
    private final URL baseUrl;
    private final int HTTP_INSUFFICIENT_STORAGE = 507;
    private final Comparator<PropfindEntryData> ASCENDING_BY_DEPTH = Comparator.comparingInt(PropfindEntryData::getDepth);

    WebDavClient(WebDavCompatibleHttpClient httpClient, WebDavCredential webDavCredential) {
        this.httpClient = httpClient;
        this.baseUrl = webDavCredential.getBaseUrl();
    }

    CloudItemList list(CloudPath folder) throws CloudProviderException {
        return this.list(folder, PROPFIND_DEPTH.ONE);
    }

    CloudItemList listExhaustively(CloudPath folder) throws CloudProviderException {
        return this.list(folder, PROPFIND_DEPTH.INFINITY);
    }

    private CloudItemList list(CloudPath folder, PROPFIND_DEPTH propfind_depth) throws CloudProviderException {
        CloudItemList cloudItemList;
        block8: {
            Response response = this.executePropfindRequest(folder, propfind_depth);
            try {
                this.checkExecutionSucceeded(response.code());
                List<PropfindEntryData> nodes = this.getEntriesFromResponse(response);
                cloudItemList = this.processDirList(nodes);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudItemList;
    }

    CloudItemMetadata itemMetadata(CloudPath path) throws CloudProviderException {
        CloudItemMetadata cloudItemMetadata;
        block8: {
            Response response = this.executePropfindRequest(path, PROPFIND_DEPTH.ZERO);
            try {
                this.checkExecutionSucceeded(response.code());
                List<PropfindEntryData> nodes = this.getEntriesFromResponse(response);
                cloudItemMetadata = this.processGet(nodes);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudItemMetadata;
    }

    private Response executePropfindRequest(CloudPath path, PROPFIND_DEPTH propfind_depth) throws IOException {
        String body = "<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>";
        Request.Builder builder = new Request.Builder().method("PROPFIND", RequestBody.create((String)"<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>", (MediaType)MediaType.parse((String)"<d:propfind xmlns:d=\"DAV:\">\n<d:prop>\n<d:resourcetype />\n<d:getcontentlength />\n<d:getlastmodified />\n</d:prop>\n</d:propfind>"))).url(this.absoluteURLFrom(path)).header("DEPTH", propfind_depth.value).header("Content-Type", "text/xml");
        return this.httpClient.execute(builder);
    }

    private List<PropfindEntryData> getEntriesFromResponse(Response response) throws IOException, SAXException {
        try (ResponseBody responseBody = response.body();){
            List<PropfindEntryData> list = new PropfindResponseParser().parse(responseBody.byteStream());
            return list;
        }
    }

    private CloudItemMetadata processGet(List<PropfindEntryData> entryData) {
        entryData.sort(this.ASCENDING_BY_DEPTH);
        return entryData.size() >= 1 ? entryData.get(0).toCloudItem() : null;
    }

    private CloudItemList processDirList(List<PropfindEntryData> entryData) {
        CloudItemList result = new CloudItemList(new ArrayList<CloudItemMetadata>());
        if (entryData.isEmpty()) {
            return result;
        }
        entryData.sort(this.ASCENDING_BY_DEPTH);
        for (PropfindEntryData childEntry : entryData.subList(1, entryData.size())) {
            result = result.add(List.of(childEntry.toCloudItem()));
        }
        return result;
    }

    CloudPath move(CloudPath from, CloudPath to, boolean replace) throws CloudProviderException {
        CloudPath cloudPath;
        block10: {
            Request.Builder builder = new Request.Builder().method("MOVE", null).url(this.absoluteURLFrom(from)).header("Destination", this.absoluteURLFrom(to).toExternalForm()).header("Content-Type", "text/xml").header("Depth", "infinity");
            if (!replace) {
                builder.header("Overwrite", "F");
            }
            Response response = this.httpClient.execute(builder);
            try {
                if (response.code() == 412) {
                    throw new AlreadyExistsException(this.absoluteURLFrom(to).toExternalForm());
                }
                this.checkExecutionSucceeded(response.code());
                cloudPath = to;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudPath;
    }

    InputStream read(CloudPath path, ProgressListener progressListener) throws CloudProviderException {
        Request.Builder getRequest = new Request.Builder().get().url(this.absoluteURLFrom(path));
        return this.read(getRequest, progressListener);
    }

    InputStream read(CloudPath path, long offset, long count, ProgressListener progressListener) throws CloudProviderException {
        Request.Builder getRequest = new Request.Builder().header("Range", String.format("bytes=%d-%d", offset, offset + count - 1L)).get().url(this.absoluteURLFrom(path));
        return this.read(getRequest, progressListener);
    }

    private InputStream read(Request.Builder getRequest, ProgressListener progressListener) throws CloudProviderException {
        try {
            Response response = this.httpClient.execute(getRequest);
            ProgressResponseWrapper countingBody = new ProgressResponseWrapper(response.body(), progressListener);
            this.checkExecutionSucceeded(response.code());
            return countingBody.byteStream();
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    CloudItemMetadata write(CloudPath file, boolean replace, InputStream data, ProgressListener progressListener) throws CloudProviderException {
        CloudItemMetadata cloudItemMetadata;
        block9: {
            if (!replace && this.exists(file)) {
                throw new AlreadyExistsException("CloudNode already exists and replace is false");
            }
            ProgressRequestWrapper countingBody = new ProgressRequestWrapper(InputStreamRequestBody.from(data), progressListener);
            Request.Builder requestBuilder = new Request.Builder().url(this.absoluteURLFrom(file)).put((RequestBody)countingBody);
            Response response = this.httpClient.execute(requestBuilder);
            try {
                this.checkExecutionSucceeded(response.code());
                cloudItemMetadata = this.itemMetadata(file);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudItemMetadata;
    }

    private boolean exists(CloudPath path) throws CloudProviderException {
        try {
            return this.itemMetadata(path) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    CloudPath createFolder(CloudPath path) throws CloudProviderException {
        CloudPath cloudPath;
        block8: {
            Request.Builder builder = new Request.Builder().method("MKCOL", null).url(this.absoluteURLFrom(path));
            Response response = this.httpClient.execute(builder);
            try {
                this.checkExecutionSucceeded(response.code());
                cloudPath = path;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CloudProviderException(e);
                }
            }
            response.close();
        }
        return cloudPath;
    }

    void delete(CloudPath path) throws CloudProviderException {
        Request.Builder builder = new Request.Builder().delete().url(this.absoluteURLFrom(path));
        try (Response response = this.httpClient.execute(builder);){
            this.checkExecutionSucceeded(response.code());
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    void checkServerCompatibility() throws ServerNotWebdavCompatibleException {
        Request.Builder optionsRequest = new Request.Builder().method("OPTIONS", null).url(this.baseUrl);
        try (Response response = this.httpClient.execute(optionsRequest);){
            this.checkExecutionSucceeded(response.code());
            boolean containsDavHeader = response.headers().names().contains("DAV");
            if (!containsDavHeader) {
                throw new ServerNotWebdavCompatibleException();
            }
        }
        catch (IOException e) {
            throw new CloudProviderException(e);
        }
    }

    void tryAuthenticatedRequest() throws UnauthorizedException {
        block2: {
            try {
                this.itemMetadata(CloudPath.of("/", new String[0]));
            }
            catch (Exception e) {
                if (!(e instanceof UnauthorizedException)) break block2;
                throw e;
            }
        }
    }

    private void checkExecutionSucceeded(int status) throws CloudProviderException {
        switch (status) {
            case 401: {
                throw new UnauthorizedException();
            }
            case 403: {
                throw new ForbiddenException();
            }
            case 404: 
            case 409: {
                throw new NotFoundException();
            }
            case 507: {
                throw new InsufficientStorageException();
            }
        }
        if (status < 199 || status > 300) {
            throw new CloudProviderException("Response code isn't between 200 and 300: " + status);
        }
    }

    URL absoluteURLFrom(CloudPath relativePath) {
        CloudPath basePath = CloudPath.of(this.baseUrl.getPath(), new String[0]).toAbsolutePath();
        CloudPath fullPath = IntStream.range(0, relativePath.getNameCount()).mapToObj(i -> relativePath.getName(i)).reduce(basePath, CloudPath::resolve);
        try {
            return new URL(this.baseUrl, fullPath.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The relative path contains invalid URL elements.");
        }
    }

    static class WebDavAuthenticator {
        WebDavAuthenticator() {
        }

        static WebDavClient createAuthenticatedWebDavClient(WebDavCredential webDavCredential) throws ServerNotWebdavCompatibleException, UnauthorizedException {
            WebDavClient webDavClient = new WebDavClient(new WebDavCompatibleHttpClient(webDavCredential), webDavCredential);
            webDavClient.checkServerCompatibility();
            webDavClient.tryAuthenticatedRequest();
            return webDavClient;
        }
    }

    private static enum PROPFIND_DEPTH {
        ZERO("0"),
        ONE("1"),
        INFINITY("infinity");

        private final String value;

        private PROPFIND_DEPTH(String value) {
            this.value = value;
        }
    }
}

