/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.localfs;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.AlreadyExistsException;
import org.cryptomator.cloudaccess.api.exceptions.CloudProviderException;
import org.cryptomator.cloudaccess.api.exceptions.NotFoundException;
import org.cryptomator.cloudaccess.api.exceptions.TypeMismatchException;

public class LocalFsCloudProvider
implements CloudProvider {
    private static final CloudPath ABS_ROOT = CloudPath.of("/", new String[0]);
    private final Path root;

    public LocalFsCloudProvider(Path root) {
        this.root = root;
    }

    private Path resolve(CloudPath cloudPath) {
        String relPath = ABS_ROOT.relativize(cloudPath).toString();
        return this.root.resolve(relPath);
    }

    private CloudItemMetadata createMetadata(Path fullPath, BasicFileAttributes attr) {
        Path relPath = this.root.relativize(fullPath);
        CloudItemType type = attr.isDirectory() ? CloudItemType.FOLDER : (attr.isRegularFile() ? CloudItemType.FILE : CloudItemType.UNKNOWN);
        Optional<Instant> modifiedDate = Optional.of(attr.lastModifiedTime().toInstant());
        Optional<Long> size = Optional.of(attr.size());
        return new CloudItemMetadata(relPath.getFileName().toString(), ABS_ROOT.resolve(relPath.toString()), type, modifiedDate, size);
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath node) {
        Path path = this.resolve(node);
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            CloudItemMetadata metadata = this.createMetadata(path, attr);
            return CompletableFuture.completedFuture(metadata);
        }
        catch (NoSuchFileException e) {
            return CompletableFuture.failedFuture(new NotFoundException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }

    @Override
    public CompletionStage<CloudItemList> list(CloudPath folder, Optional<String> pageToken) {
        Path folderPath = this.resolve(folder);
        try {
            final ArrayList<CloudItemMetadata> items = new ArrayList<CloudItemMetadata>();
            LocalFsCloudProvider provider = this;
            Files.walkFileTree(folderPath, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    items.add(LocalFsCloudProvider.this.createMetadata(file, attrs));
                    return FileVisitResult.CONTINUE;
                }
            });
            return CompletableFuture.completedFuture(new CloudItemList(items, Optional.empty()));
        }
        catch (NoSuchFileException e) {
            return CompletableFuture.failedFuture(new NotFoundException(e));
        }
        catch (NotDirectoryException e) {
            return CompletableFuture.failedFuture(new TypeMismatchException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }

    @Override
    public CompletionStage<InputStream> read(CloudPath file, long offset, long count, ProgressListener progressListener) {
        Path filePath = this.resolve(file);
        try {
            SeekableByteChannel ch = Files.newByteChannel(filePath, StandardOpenOption.READ);
            ch.position(offset);
            return CompletableFuture.completedFuture(ByteStreams.limit((InputStream)Channels.newInputStream(ch), (long)count));
        }
        catch (NoSuchFileException e) {
            return CompletableFuture.failedFuture(new NotFoundException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }

    @Override
    public CompletionStage<CloudItemMetadata> write(CloudPath file, boolean replace, InputStream data, ProgressListener progressListener) {
        CompletableFuture<CloudItemMetadata> completableFuture;
        block10: {
            Path filePath = this.resolve(file);
            EnumSet<StandardOpenOption> options = replace ? EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING) : EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            FileChannel ch = FileChannel.open(filePath, options, new FileAttribute[0]);
            try {
                long size = ch.transferFrom(Channels.newChannel(data), 0L, Long.MAX_VALUE);
                Instant modifiedDate = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
                CloudItemMetadata metadata = new CloudItemMetadata(file.getFileName().toString(), file, CloudItemType.FILE, Optional.of(modifiedDate), Optional.of(size));
                completableFuture = CompletableFuture.completedFuture(metadata);
                if (ch == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return CompletableFuture.failedFuture(new NotFoundException(e));
                }
                catch (FileAlreadyExistsException e) {
                    return CompletableFuture.failedFuture(new AlreadyExistsException(e));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new CloudProviderException(e));
                }
            }
            ch.close();
        }
        return completableFuture;
    }

    @Override
    public CompletionStage<CloudPath> createFolder(CloudPath folder) {
        Path folderPath = this.resolve(folder);
        try {
            Files.createDirectory(folderPath, new FileAttribute[0]);
            return CompletableFuture.completedFuture(folder);
        }
        catch (FileAlreadyExistsException e) {
            return CompletableFuture.failedFuture(new AlreadyExistsException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }

    @Override
    public CompletionStage<Void> delete(CloudPath node) {
        Path path = this.resolve(node);
        try {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            return CompletableFuture.completedFuture(null);
        }
        catch (NoSuchFileException e) {
            return CompletableFuture.failedFuture(new NotFoundException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }

    @Override
    public CompletionStage<CloudPath> move(CloudPath source, CloudPath target, boolean replace) {
        Path src = this.resolve(source);
        Path dst = this.resolve(target);
        try {
            EnumSet<StandardCopyOption> options = replace ? EnumSet.of(StandardCopyOption.REPLACE_EXISTING) : EnumSet.noneOf(StandardCopyOption.class);
            Files.move(src, dst, (CopyOption[])options.toArray(CopyOption[]::new));
            return CompletableFuture.completedFuture(target);
        }
        catch (NoSuchFileException e) {
            return CompletableFuture.failedFuture(new NotFoundException(e));
        }
        catch (FileAlreadyExistsException e) {
            return CompletableFuture.failedFuture(new AlreadyExistsException(e));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new CloudProviderException(e));
        }
    }
}

