/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.api;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudPath;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.api.exceptions.AlreadyExistsException;

public interface CloudProvider {
    public CompletionStage<CloudItemMetadata> itemMetadata(CloudPath var1);

    public CompletionStage<CloudItemList> list(CloudPath var1, Optional<String> var2);

    default public CompletionStage<CloudItemList> listExhaustively(CloudPath folder) {
        return this.listExhaustively(folder, CloudItemList.empty());
    }

    private CompletionStage<CloudItemList> listExhaustively(CloudPath folder, CloudItemList itemList) {
        return this.list(folder, itemList.getNextPageToken()).thenCompose(nextItems -> {
            CloudItemList combined = itemList.add(nextItems.getItems(), nextItems.getNextPageToken());
            if (nextItems.getNextPageToken().isPresent()) {
                return this.listExhaustively(folder, combined);
            }
            return CompletableFuture.completedStage(combined);
        });
    }

    default public CompletionStage<InputStream> read(CloudPath file, ProgressListener progressListener) {
        return this.read(file, 0L, Long.MAX_VALUE, progressListener);
    }

    public CompletionStage<InputStream> read(CloudPath var1, long var2, long var4, ProgressListener var6);

    public CompletionStage<CloudItemMetadata> write(CloudPath var1, boolean var2, InputStream var3, ProgressListener var4);

    public CompletionStage<CloudPath> createFolder(CloudPath var1);

    default public CompletionStage<CloudPath> createFolderIfNonExisting(CloudPath folder) {
        return this.createFolder(folder).handle((createdFolder, exception) -> {
            if (exception == null) {
                if (!1.$assertionsDisabled && createdFolder == null) {
                    throw new AssertionError();
                }
                return CompletableFuture.completedFuture(createdFolder);
            }
            if (exception instanceof AlreadyExistsException) {
                return CompletableFuture.completedFuture(folder);
            }
            return CompletableFuture.failedFuture(exception);
        }).thenCompose(Function.identity());
    }

    public CompletionStage<Void> delete(CloudPath var1);

    public CompletionStage<CloudPath> move(CloudPath var1, CloudPath var2, boolean var3);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

