/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudProvider;
import org.cryptomator.cloudaccess.api.ProgressListener;
import org.cryptomator.cloudaccess.webdav.ServerNotWebdavCompatibleException;
import org.cryptomator.cloudaccess.webdav.UnauthorizedException;
import org.cryptomator.cloudaccess.webdav.WebDavClient;
import org.cryptomator.cloudaccess.webdav.WebDavCredential;

public class WebDavCloudProvider
implements CloudProvider {
    private final WebDavClient webDavClient;

    private WebDavCloudProvider(WebDavCredential webDavCredential) {
        this.webDavClient = WebDavClient.WebDavAuthenticator.createAuthenticatedWebDavClient(webDavCredential);
    }

    public static WebDavCloudProvider from(WebDavCredential webDavCredential) throws UnauthorizedException, ServerNotWebdavCompatibleException {
        return new WebDavCloudProvider(webDavCredential);
    }

    @Override
    public CompletionStage<CloudItemMetadata> itemMetadata(Path node) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.itemMetadata(node));
    }

    @Override
    public CompletionStage<CloudItemList> list(Path folder, Optional<String> pageToken) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.list(folder));
    }

    @Override
    public CompletionStage<CloudItemList> listExhaustively(Path folder) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.listExhaustively(folder));
    }

    @Override
    public CompletionStage<InputStream> read(Path file, ProgressListener progressListener) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.read(file, progressListener));
    }

    @Override
    public CompletionStage<InputStream> read(Path file, long offset, long count, ProgressListener progressListener) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.read(file, offset, count, progressListener));
    }

    @Override
    public CompletionStage<CloudItemMetadata> write(Path file, boolean replace, InputStream data, ProgressListener progressListener) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.write(file, replace, data, progressListener));
    }

    @Override
    public CompletionStage<Path> createFolder(Path folder) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.createFolder(folder));
    }

    @Override
    public CompletionStage<Void> delete(Path node) {
        return CompletableFuture.runAsync(() -> this.webDavClient.delete(node));
    }

    @Override
    public CompletionStage<Path> move(Path source, Path target, boolean replace) {
        return CompletableFuture.supplyAsync(() -> this.webDavClient.move(source, target, replace));
    }
}

